

#if !defined __USER_IO_X_H
#define __USER_IO_X_H

#include <X11/Xlib.h>

#ifdef LINUX
#include "matrix.h"
#endif

#include "WIN_VIRTUAL.h"
#include "user_io.h"


/* **********************************************************************
********************************************************************** */
class user_io_X : public user_io {

   protected:
      Display *mdisplay;

#ifdef LINUX
      int  joy_fd;
      vector4uc joy_count;
      int  button[MAXBUTTON];
      float axis[MAXJOYAXIS];
      float pov[2];
#endif

      void poll_keyboard();
      void poll_mouse();
      void poll_joystick();

   public:
      user_io_X();
      virtual ~user_io_X();

      void flush_event_queue();
      void set_win(Display *d, Window w);
      void set_win(VIRTUALwindow *win);
};

#endif

