

#if !defined __USER_IO_H
#define __USER_IO_H

#include "timer.h"
#include "basic_dt.h"

#ifdef WIN32
#define MAXKEYS             256
#else
#define MAXKEYS             512
#endif

#define CONTROLMOUSE        0
#define CONTROLJOYSTICK     1
#define CONTROLKEYBOARD     2

#define POV_DEFAULT          -1.0f

#define JOYMAX              1000
#define JOYMIN              -1000
#define JOYNORMALIZE        0.001

#define JOYDEAD             1000        // 10.00 %
#define JOYSAT              1000        // 10.00 %

#define BUTTONLEFT          0x001
#define BUTTONMIDDLE        0x002
#define BUTTONRIGHT         0x004
#define BUTTON1             0x008
#define BUTTON2             0x010
#define BUTTON3             0x020
#define BUTTON4             0x040
#define MAXBUTTON           4

#define AXIS_X           0
#define AXIS_PITCH       0
#define AXIS_Y           1
#define AXIS_YAW         1
#define AXIS_Z           2
#define AXIS_ROLL        2
#define AXIS_THROTTLE    3
#define MAXJOYAXIS       4
#define AXIS_MOUSE_X     4
#define AXIS_MOUSE_Y     5
#define MAXAXIS          6

#define KEYSTROKE_QUIT            0
#define KEYSTROKE_PAUSE           1
#define KEYSTROKE_FORWARD         2
#define KEYSTROKE_BACKWARD        3
#define KEYSTROKE_YAW_LEFT        4
#define KEYSTROKE_YAW_RIGHT       5
#define KEYSTROKE_PITCH_FORWARD   6
#define KEYSTROKE_PITCH_BACKWARD  7
#define KEYSTROKE_ROLL_LEFT       8
#define KEYSTROKE_ROLL_RIGHT      9
#define KEYSTROKE_FIRE_PRIMARY    10
#define KEYSTROKE_FIRE_SECONDARY  11
#define KEYSTROKE_SNAPSHOT        12
#define KEYSTROKE_RECORD          13
#define KEYSTROKE_HAT_UP          14
#define KEYSTROKE_HAT_DOWN        15
#define KEYSTROKE_HAT_LEFT        16
#define KEYSTROKE_HAT_RIGHT       17
#define KEYSTROKE_HAT_LOCK        18

#define KEYMOVE             0.5
#define KEYMOVE_THRESHOLD   0.25

#define KEYSTROKE_ESC    0
#define KEYSTROKE_F1     1
#define KEYSTROKE_F2     2
#define KEYSTROKE_F3     3
#define KEYSTROKE_F4     4
#define KEYSTROKE_F5     5
#define KEYSTROKE_F6     6
#define KEYSTROKE_F7     7
#define KEYSTROKE_F8     8
#define KEYSTROKE_F9     9
#define KEYSTROKE_F10   10
#define KEYSTROKE_F11   11
#define KEYSTROKE_F12   12

#define KEYSTROKE_GRAVE     13
#define KEYSTROKE_1         14
#define KEYSTROKE_2         15
#define KEYSTROKE_3         16
#define KEYSTROKE_4         17
#define KEYSTROKE_5         18
#define KEYSTROKE_6         19
#define KEYSTROKE_7         20
#define KEYSTROKE_8         21
#define KEYSTROKE_9         22
#define KEYSTROKE_0         23
#define KEYSTROKE_MINUS     24
#define KEYSTROKE_PLUS      25
#define KEYSTROKE_BACKSPACE 26

#define KEYSTROKE_TAB       27
#define KEYSTROKE_Q         28
#define KEYSTROKE_W         29
#define KEYSTROKE_E         30
#define KEYSTROKE_R         31
#define KEYSTROKE_T         32
#define KEYSTROKE_Y         33
#define KEYSTROKE_U         34
#define KEYSTROKE_I         35
#define KEYSTROKE_O         36
#define KEYSTROKE_P         37
#define KEYSTROKE_LBRACKET  38
#define KEYSTROKE_RBRACKET  39
#define KEYSTROKE_BACKSLASH 40

#define KEYSTROKE_A         41
#define KEYSTROKE_S         42
#define KEYSTROKE_D         43
#define KEYSTROKE_F         44
#define KEYSTROKE_G         45
#define KEYSTROKE_H         46
#define KEYSTROKE_J         47
#define KEYSTROKE_K         48
#define KEYSTROKE_L         49
#define KEYSTROKE_SEMICOLON 50
#define KEYSTROKE_QUOTE     51
#define KEYSTROKE_RETURN    52


#define KEYSTROKE_LSHIFT       53
#define KEYSTROKE_Z            54
#define KEYSTROKE_X            55
#define KEYSTROKE_C            56
#define KEYSTROKE_V            57
#define KEYSTROKE_B            58
#define KEYSTROKE_N            59
#define KEYSTROKE_M            60
#define KEYSTROKE_COMMA        61
#define KEYSTROKE_PERIOD       62
#define KEYSTROKE_FORWARDSLASH 63
#define KEYSTROKE_RSHIFT       64

#define KEYSTROKE_LCONTROL     65
#define KEYSTROKE_LALT         66
#define KEYSTROKE_SPACE        67
#define KEYSTROKE_RALT         68
#define KEYSTROKE_RCONTROL     69

#define KEYSTROKE_CSRUP        70
#define KEYSTROKE_CSRDOWN      71
#define KEYSTROKE_CSRLEFT      72
#define KEYSTROKE_CSRRIGHT     73
#define KEYSTROKE_GINSERT      74
#define KEYSTROKE_GHOME        75
#define KEYSTROKE_GPAGEUP      76
#define KEYSTROKE_GDELETE      77
#define KEYSTROKE_GEND         78
#define KEYSTROKE_GPAGEDOWN    79

#define KEYSTROKE_NBACKSLASH   80
#define KEYSTROKE_NASTRICK     81
#define KEYSTROKE_NMINUS       82
#define KEYSTROKE_NPLUS        83
#define KEYSTROKE_NENTER       84
#define KEYSTROKE_N7           85
#define KEYSTROKE_N8           86
#define KEYSTROKE_N9           87
#define KEYSTROKE_N4           88
#define KEYSTROKE_N5           89
#define KEYSTROKE_N6           90
#define KEYSTROKE_N1           91
#define KEYSTROKE_N2           92
#define KEYSTROKE_N3           93
#define KEYSTROKE_N0           94
#define KEYSTROKE_NDELETE      95
#define MAXKEYSTROKE           96

#define FLAG_IO_NULL            0x00000000
#define FLAG_IO_MOUSE_RECENTER  0x00000001
#define FLAG_IO_MOUSE_READJUST  0x00000002
#define FLAG_IO_MOUSE_CONSTRAIN 0x00000004
#define FLAG_IO_MOUSE_DEADZONE  0x00000008
#define FLAG_IO_ALL             0xffffffff


/* **********************************************************************
********************************************************************** */
class user_io {

   protected:
      unsigned int flags;

      void tether_mouse(int x, int y, int winx, int winy);
      
      virtual void poll_keyboard() = 0;
      virtual void poll_mouse() = 0;
      virtual void poll_joystick() = 0;
      
   public:
      // keyboard
      char pure_keypress[MAXKEYS], status_keypress[MAXKEYS], status_keyold[MAXKEYS];
      int keyboard_driver[256];

      int *keyxlator;
      int commandcount;

      // mouse & joystick
      int   status_buttonpress;
      float control[MAXAXIS], joyaxis[MAXAXIS];
      int   center[2];

      int *buttonxlator;
      int buttoncount;

      float povdegree;
      float keymove[3];

      user_io();
      virtual ~user_io();

      int read_commands(char *filename);

      int translate(int x) {
         return status_keypress[keyxlator[x]];
      }

      int translate_stroke(int x) {
         return status_keypress[keyxlator[x]] && !status_keyold[keyxlator[x]];
      }

      int key_press(int x) {
         return status_keypress[keyboard_driver[x]];
      }
      
      int key_stroke(int x) {
         return status_keypress[keyboard_driver[x]] && !status_keyold[keyboard_driver[x]];
      }
      
      void process_events(timer_type *timer);

      void flag_on(unsigned int x);
      void flag_off(unsigned int x);
      
      virtual void get_events();
      virtual void flush_event_queue() {}
};

extern string_type FILENAME_KEYBOARD_DECODER;
extern int CONTROLLER;

#endif

