
#if !defined __TIMER_H
#define __TIMER_H


#define TIME_MASK 0x0fff
#define MAX_TIME 0x1000

#ifdef WIN32

#include <windows.h>
#include <sys/timeb.h>

typedef struct _timeb TIME_STRUCT;

#define GETTIME(xxx)    _ftime(xxx)
#define TIME2FLOAT(xxx) ((xxx.time  & TIME_MASK) + xxx.millitm*0.001)
#define TIME2DOUBLE(xxx) (xxx.time + xxx.millitm*0.001)
#define TIME2INT(xxx, yyy, zzz) { *(yyy) = xxx.time; *(zzz) = xxx.millitm*1000; }
#define SLEEP(xxx) Sleep((int)((xxx)*1000))

#else

#include <sys/time.h>
#include <time.h>
#include <unistd.h>

typedef struct timeval TIME_STRUCT;

#define GETTIME(xxx)    gettimeofday(xxx, (struct timezone *)NULL)
#define TIME2FLOAT(xxx) ((xxx.tv_sec & TIME_MASK) + xxx.tv_usec*0.000001)
#define TIME2DOUBLE(xxx) (xxx.tv_sec + xxx.tv_usec*0.000001)
#define TIME2INT(xxx, yyy, zzz) { *(yyy) = xxx.tv_sec; *(zzz) = xxx.tv_usec; }

#ifdef SGI

#define SLEEP(xxx) sginap((int)((xxx)*CLK_TCK))

#else

#define SLEEP(xxx) ((xxx) < 1.0f ? usleep((int)((xxx)*1000000)) : sleep((int)(xxx)))

#endif

#endif


/* ************************************************************************
   on 166MHz Pentium clock() ticks are 10 milliseconds apart (0.01) accuracy
************************************************************************ */
class timer_type {

   protected:
      float oldtime;
      unsigned int pause_flag;

   public:
      float speedscale, backscale;

      timer_type() { pause_flag = 0; }
      virtual ~timer_type() {}
      
      unsigned int query_pause() { return pause_flag; }

      void init();
      int  tick();
      int  manual_tick(float increment);
      void pause(int state);
};

#endif
