

#if !defined __TEXTURE_H
#define __TEXTURE_H

#include "datatype.h"


#define TEXTURE    0
#define TEXTURE256 1
#define VIDEO      2

#define TEXTURE_BLOCK_TYPE_TEXTURE    0x0001
#define TEXTURE_BLOCK_TYPE_TEXTURE256 0x0002

typedef enum { VIDONE, VIDREPEAT } vidplaytype;


/* ********************************************************************
******************************************************************** */
class mipmapbase {

   public:
      float compression, idiff;	// (inverse difference between this one and previous one)
      int   *compress_length, *compress_width;

      mipmapbase();
      virtual ~mipmapbase();

      virtual void init() = 0;
      virtual void dest() = 0;
};


/* ********************************************************************
******************************************************************** */
class mipmaptype : public mipmapbase {

   public:
      mapul *tob;

      mipmaptype();
      virtual ~mipmaptype();

      void init();
      void dest();
};


/* ********************************************************************
******************************************************************** */
class texture_block : public basic_texture_block {

   public:
      // basic_texture_block
      int query_whatami() { return TEXTURE_BLOCK_TYPE_TEXTURE; }

      // texture_block
      mapul tob;
      int mipmapcount;
      mipmaptype *mipmap;

      texture_block() { mipmap = NULL; }

      virtual ~texture_block() {
         if (mipmap) {
            mipmap[0].init();
            delete [] mipmap;
         }

      }

};


/* ********************************************************************
******************************************************************** */
class texture : public texbase {

   protected:
      basic_texture_block *tblock;
      
      int  post_process_texture();

      unsigned int query_bifilter_texel(float x, float y, float *color);

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response);
      void replace_data(void *subresource);

      // texbase
      int pre_process_texture();
      void build_mipmaps(dbl_llist_manager *image_handler, int flip);

      int read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);
      int skim_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);

      int query_whatami() { return TEXTURE; }
      unsigned int query_texel(float x, float y, float *color, int frame, float d);

      // texture
      texture() { tblock = NULL; }
      virtual ~texture() { if (tblock) delete tblock; }

      // used to get tblock while processing new data - avoids possible infinite loop associated w/ query_data
      void *get_data() { return tblock; }
};


/* ********************************************************************
******************************************************************** */
class mipmaptype256 : public mipmapbase {

   public:
      mapuc *tob;
      union { unsigned char cpalette[1024]; unsigned int ipalette[256]; };

      mipmaptype256();
      virtual ~mipmaptype256();

      void init();
      void dest();
};


/* ********************************************************************
******************************************************************** */
class texture_block256 : public basic_texture_block {

   public:
      // basic_texture_block
      int query_whatami() { return TEXTURE_BLOCK_TYPE_TEXTURE256; }

      // texture_block256
      union { unsigned char cpalette[1024]; unsigned int ipalette[256]; };

      mapuc tob;

      int mipmapcount;
      mipmaptype256 *mipmap;

      texture_block256() { mipmap = NULL; }

      virtual ~texture_block256() {
         if (mipmap) {
            mipmap[0].init();
            delete [] mipmap;
         }

      }

};


/* ********************************************************************
******************************************************************** */
class texture256 : public texbase {

   protected:
      basic_texture_block *tblock;

      int  post_process_texture();

      unsigned int query_bifilter_texel(float x, float y, float *color);

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response);
      void replace_data(void *subresource);

      // texbase
      int pre_process_texture();
      void build_mipmaps(dbl_llist_manager *image_handler, int flip);

      int read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);
      int skim_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);

      int query_whatami() { return TEXTURE256; }
      unsigned int query_texel(float x, float y, float *color, int frame, float d);

      // texture256
      texture256() { tblock = NULL; }
      virtual ~texture256() { if (tblock) delete tblock; }

      // used to get tblock while processing new data - avoids possible infinite loop associated w/ query_data
      void *get_data() { return tblock; }
};



/* ********************************************************************
   Dont need destructor -> texture's kept in main list.... :)
   assumption : all textures in video are same dimensions
   fact : frame #s are non-negative
******************************************************************** */
class texvid : public texbase {

   protected:
      texbase **tob;
      int count;
      vidplaytype vpflag;

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response);
      void replace_data(void *subresource);

      // texbase
      int pre_process_texture();

      int read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);
      int skim_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) { return read_texture(sinfile, image_handler, loader, flag256, flip); }

      int query_whatami() { return VIDEO; }
      unsigned int query_texel(float x, float y, float *color, int frame, float d);

      // texvid
      texvid() { tob = NULL; }
      virtual ~texvid() { if (tob) delete [] tob; }
};

#endif

