

#if !defined __SUPERCLASS_H
#define __SUPERCLASS_H


#include <stdio.h>

#include "dataio.h"


#define CLASS_GENERIC       0
#define CLASS_LIGHT         1
#define CLASS_CAMERA        2
#define CLASS_OBJECT        3
#define CLASS_ANIMATION     4

#define OBJECT_GENERIC      0

#define OBJECT_EYE          1
#define OBJECT_CAMERA       2
#define OBJECT_POINT        3
#define OBJECT_FAR          4

#define OBJECT_PC           10
#define OBJECT_BASENULL     11
#define OBJECT_POLYGON      12
#define OBJECT_SPATCH       13
#define OBJECT_PARTICLE     14
#define OBJECT_LINE         15
#define OBJECT_RADIANT      16
#define OBJECT_SPHERE       17
#define OBJECT_CYLINDER     18
#define OBJECT_CONE         19
#define OBJECT_SBFAST       20

#define OBJECT_QUARK        30
#define OBJECT_ATOM         31
#define OBJECT_BOID         32
#define OBJECT_BOIDBAIT     33
#define OBJECT_FLIGHT       34
#define OBJECT_WWDIGO       35
#define OBJECT_LOCK         36
#define OBJECT_ELECTRON     37
#define OBJECT_PHOTON       38
#define OBJECT_NEUTRON      39
#define OBJECT_SHELL        40
#define OBJECT_TACHYON      41
#define OBJECT_CHAIN        42
#define OBJECT_ION          43
#define OBJECT_BUCKEY       44
#define OBJECT_TUBE         45
#define OBJECT_FUNNEL       46
#define OBJECT_HELIX        47

#define STATUSFLAG_VOID	        0x00
#define STATUSFLAG_LOADABLE     0x01
#define STATUSFLAG_LOADED       0x02
#define STATUSFLAG_TIME_UPDATE  0x04

#define RESOURCE_NULL           0x00000000

#define FRUSTUM_FRONT  0
#define FRUSTUM_BACK   1
#define FRUSTUM_LEFT   2
#define FRUSTUM_RIGHT  3
#define FRUSTUM_TOP    4
#define FRUSTUM_BOTTOM 5
#define FRUSTUM_COUNT  6

#define FRUSTUM_CLIP_NONE   0x00
#define FRUSTUM_CLIP_FRONT  0x01
#define FRUSTUM_CLIP_BACK   0x02
#define FRUSTUM_CLIP_LEFT   0x04
#define FRUSTUM_CLIP_RIGHT  0x08
#define FRUSTUM_CLIP_TOP    0x10
#define FRUSTUM_CLIP_BOTTOM 0x20
#define FRUSTUM_CLIP_ALL    0x3f

/* *************************************************************
************************************************************* */
class resource_type : public dbl_llist {

   public:
      string_type dataname;
      string_type altname;
      float access_time;
      unsigned int statusflag;

      resource_type();
      virtual ~resource_type() {}

      virtual void update(float current_time) = 0;
      virtual void *query_data() { return NULL; }
      virtual int  query_data(int type, void *key, void *response) { return 0; }
      virtual void replace_data(void *subresource) = 0;
};


/* *************************************************************
************************************************************* */
class resource_manager {

   protected:
      sfile sinfile;

      virtual void local_init();
      virtual void local_reset();
      
   public:
      resource_manager();
      virtual ~resource_manager();
      
      virtual void init(int x);
      virtual void reset();

      virtual void register_resource_object(int type, void *data);
      virtual void *find_resource_object(int type, char *id, char *alias);
      virtual void *get_resource_object(int type);
      virtual void update(float current_time);
};


/* *************************************************************
************************************************************* */
class superclass {

   public:
      int id;

      superclass() { id = 0; }
      virtual ~superclass() {};

      virtual int query_category() { return CLASS_GENERIC; }
      virtual int query_whatami()  { return OBJECT_GENERIC; }
      virtual int query_whatwasi(int type);
      virtual int parse(FILE *infile, char *token);
      virtual void preprocess(void *data);
};


/* *************************************************************
************************************************************* */
class frameclass : public superclass {

   public:
      // superclass
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // frameclass

      // what frame this object renders in (preprocessed rendering)
      int frame;
      frameclass *next;

      frameclass() { next = NULL; frame = 0; }
      virtual ~frameclass() {}

      virtual int dump_frame(FILE *outfile);
};


/* *************************************************************
************************************************************* */
class loader : public dbl_llist {

   protected:
      char *object_name;

      virtual superclass *make_object() = 0;

   public:

      loader() { object_name = NULL; }
      virtual ~loader() {}

      char *query_name() { return object_name; }

      virtual superclass *parse(FILE *infile, char *token);
};


/* *************************************************************
************************************************************* */
class doer : public string_binary_data {

   protected:
      void *fcn, *init_fcn;
      
   public:

      virtual ~doer() {}

      int  set(char *tmpstr, void *func_call, void *init_call = (void *)NULL);
      int  query_data(void *x) { return ((int (*)(void *))fcn)(x); }
      void init();
};


extern char TOKEN_FRAME_STR[];
extern char TOKEN_LOCATION_STR[];
extern char TOKEN_UP_STR[];
extern char TOKEN_AMBIENT_STR[];
extern char TOKEN_DIFFUSE_STR[];
extern char TOKEN_FATT_STR[];
extern char TOKEN_DIRECTION_STR[];
extern char TOKEN_2D_TEXTURE_STR[];
extern char TOKEN_3D_TEXTURE_STR[];
extern char TOKEN_SHADE_STR[];
extern char TOKEN_DISTANCE2PLANE_STR[];
extern char TOKEN_LENGTH_STR[];
extern char TOKEN_WIDTH_STR[];
extern char TOKEN_COA_STR[];
extern char TOKEN_TYPE_STR[];
extern char TOKEN_TOP_RADIUS_STR[];
extern char TOKEN_BOTTOM_RADIUS_STR[];
extern char TOKEN_LUMINATE_STR[];
extern char TOKEN_RAYCAST_STR[];
extern char TOKEN_ROTATE_X_STR[];
extern char TOKEN_ROTATE_Y_STR[];
extern char TOKEN_ROTATE_Z_STR[];
extern char TOKEN_SCALE_STR[];
extern char TOKEN_SHADOW_STR[];
extern char TOKEN_TR_MATRIX_STR[];
extern char TOKEN_TRANSLATE_STR[];
extern char TOKEN_TRANSPARENT_STR[];
extern char TOKEN_RADIUS_STR[];
extern char TOKEN_AXIS_STR[];
extern char TOKEN_AXIS_X_STR[];
extern char TOKEN_AXIS_Y_STR[];
extern char TOKEN_AXIS_Z_STR[];
extern char TOKEN_BIPLANE_STR[];
extern char TOKEN_FILE_STR[];
extern char TOKEN_INVISO_STR[];
extern char TOKEN_HOLLOW_STR[];
extern char TOKEN_INNER_RADIUS_STR[];
extern char TOKEN_OUTER_RADIUS_STR[];
extern char TOKEN_BACK_STR[];
extern char TOKEN_DITHER_STR[];
extern char TOKEN_DISPLACEMENT_STR[];
extern char TOKEN_H_STR[];
extern char TOKEN_LACUNARITY_STR[];
extern char TOKEN_OCTAVES_STR[];
extern char TOKEN_GHOST_STR[];
extern char TOKEN_OVERWRITE_STR[];
extern char TOKEN_FOREGROUND_STR[];
extern char TOKEN_MIDGROUND_STR[];
extern char TOKEN_BACKGROUND_STR[];
extern char TOKEN_LIST_STR[];                   // magic for .list files

extern char TOKEN_LIGHT_STR[];
extern char TOKEN_POINT_STR[];
extern char TOKEN_BEAM_FAR_STR[];
extern char TOKEN_BEAM_POINT_STR[];
extern char TOKEN_FAR_STR[];
extern char TOKEN_SIMPLE_POINT_STR[];
extern char TOKEN_SIMPLE_BEAM_FAR_STR[];
extern char TOKEN_SIMPLE_BEAM_POINT_STR[];
extern char TOKEN_SIMPLE_FAR_STR[];

extern char TOKEN_CAMERA_STR[];

extern char TOKEN_GEOCONE_STR[];
extern char TOKEN_GEOCYLINDER_STR[];
extern char TOKEN_GEOSPHERE_STR[];
extern char TOKEN_LINE_STR[];
extern char TOKEN_PARTICLE_STR[];
extern char TOKEN_POLYGON_STR[];
extern char TOKEN_RADIANT_STR[];
extern char TOKEN_SBFAST_STR[];
extern char TOKEN_SPATCH_STR[];
                                                // anitroll specific
extern char TOKEN_ORIGIN_STR[];
extern char TOKEN_BOUND_STR[];
extern char TOKEN_CHILDREN_STR[];
extern char TOKEN_NAME_STR[];
extern char TOKEN_PIVOT_STR[];
extern char TOKEN_ROTATE_LOCAL_X_STR[];
extern char TOKEN_ROTATE_LOCAL_Y_STR[];
extern char TOKEN_ROTATE_LOCAL_Z_STR[];
extern char TOKEN_TR_LOCAL_MATRIX_STR[];
extern char TOKEN_TRANSLATE_LOCAL_STR[];
extern char TOKEN_DEATH_STR[];
extern char TOKEN_DECAY_STR[];
extern char TOKEN_INTENSITY_STR[];
extern char TOKEN_END_POINT_STR[];
extern char TOKEN_ORIENTATION_MX_STR[];
extern char TOKEN_LOCK_STR[];
extern char TOKEN_UNLOCK_STR[];
extern char TOKEN_OFFSET_STR[];
extern char TOKEN_BOID_RANGE_STR[];
extern char TOKEN_COLLISION_LOSS_STR[];
extern char TOKEN_FRICTION_PER_SEC_STR[];
extern char TOKEN_GRAVITY_STR[];
extern char TOKEN_LEADER_RANGE_STR[];
extern char TOKEN_MAX_TURN_RADIUS_STR[];
extern char TOKEN_MAX_ACCELERATION_STR[];
extern char TOKEN_RED_ALERT_STR[];
extern char TOKEN_VELOCITY_STR[];
extern char TOKEN_VELOCITY_RANGE_STR[];
extern char TOKEN_YELLOW_ALERT_STR[];
extern char TOKEN_NULL_STR[];

extern char TOKEN_ATOM_STR[];
extern char TOKEN_QUARK_STR[];
extern char TOKEN_FLIGHT_STR[];
extern char TOKEN_BOID_STR[];
extern char TOKEN_BOIDBAIT_STR[];
extern char TOKEN_NEUTRON_STR[];
extern char TOKEN_ELECTRON_STR[];
extern char TOKEN_PHOTON_STR[];
extern char TOKEN_TACHYON_STR[];
extern char TOKEN_SHELL_STR[];
extern char TOKEN_ION_STR[];
extern char TOKEN_HELIX_STR[];
extern char TOKEN_TUBE_STR[];
extern char TOKEN_FUNNEL_STR[];
extern char TOKEN_CHAIN_STR[];
extern char TOKEN_BUCKEY_STR[];

extern resource_manager *global_resource_manager;

#endif
