

#if !defined __SPHRTYPE_H
#define __SPHRTYPE_H

#include "polytype.h"


#define COL_POLYGON     0
#define COL_SUBSPHERE_1 1


typedef struct {

   int collision_flag;
   float range2;
   vector4f pos;
   vector3f normal;
} coldata_type;


/* *************************************************************
************************************************************* */
class basesphere : public dbl_llist {

   public:
      vector3f center;
      float radius;
      int level;
      
      virtual ~basesphere() {}
};


/* *************************************************************
************************************************************* */
class colsphere : public basesphere {

   public:
      int count;
      int *index;

      int read_data(FILE *infile);
      int write_data(FILE *outfile);

      int collision(colsphere *sphrlist, polygon_object_type *pot, char *findex, float sphr_radius, float *sphr_center, float *pos, float *normal, int lvl);
      int sphere_poly_intersect(float sphr_radius, float *sphr_center, int face, polygon_object_type *pot, float *pos, float *normal);
      int lineseg_collision(colsphere *sphrlist, polygon_object_type *pot, char *findex,
                            float *midpt, float mid_radius, float *ray,
                            float *start, float *end, float *pos, float *normal, int *ret, float *t, int lvl);
      int line_collision(colsphere *sphrlist, polygon_object_type *pot, char *findex,
                         float *pt, float *ray, float *pos, float *normal, int *ret, float *t, int lvl);


      colsphere() { index = NULL; }
      virtual ~colsphere() { if (index) delete [] index; }
};


/* *************************************************************
************************************************************* */
class sphere_block {

   public:
      int       countsphere;
      colsphere *slist;

      sphere_block() { slist = NULL; }
      virtual ~sphere_block() { if (slist) delete [] slist; }
};


/* *************************************************************
************************************************************* */
class spheretype : public datatype {

   protected:
      sphere_block *sblock;

   public:
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);

      void init();
      void dest();

      int read_data(char *filename);

      spheretype() { init(); }
      spheretype(int count);

      virtual ~spheretype() { dest(); }

      float query_radius();
      int write_data(char *filename);
};


spheretype *build_quadspheres(polytype *ob, int level);


#endif

