



#if !defined (__SPHERE_H)
#define __SPHERE_H

#include "geo.h"

/* *************************************************************
************************************************************* */
class sphere : public geo {

   protected:

      // pc
      void transform(eye *parm);

      // geo
      float calc_area();
      void pg(eye *parm, light *lmain, light *spot, zbuffer *zbuff);
      void lt(spotlight *spot);
      void geo2poly(texpolygon **ptob, shaderlisttype *slist);

   public:
   
      // superclass
      int  query_whatami() { return OBJECT_SPHERE; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // frameclass
      int  dump_frame(FILE *outfile);

      // pc
      void bound_sphere();
      void datacopy();

      // sphere
      vector3f master_wscale, wscale;

      sphere() { master_wscale[0] = master_wscale[1] = master_wscale[2] = 1.0; }
      virtual ~sphere() {}
};


/* *************************************************************
************************************************************* */
class sphere_loader : public loader {

   public:
      superclass *make_object() { return new sphere; }
      sphere_loader() { object_name = TOKEN_GEOSPHERE_STR; }
      virtual ~sphere_loader() {}
};

#endif

