

#if !defined __SPB_LOAD_H
#define __SPB_LOAD_H

#include "shader.h"

#include "sphrtype.h"

#include "spg_load.h"


#define ENCODE_TAG(u1, u2, u3, u4) ((((((u4<<8) | u3)<<8) | u2)<<8) | u1)

#define MASTER_BLOCK_TAG    ENCODE_TAG('S', 'B', '1', '0')
#define OBJECT_BLOCK_TAG    ENCODE_TAG('O', 'B', 'J', 'B')
#define MATERIAL_BLOCK_TAG  ENCODE_TAG('I', 'L', 'M', 'B')
#define MATERIAL2_BLOCK_TAG ENCODE_TAG('I', 'M', '2', 'B')
#define UV_BLOCK_TAG        ENCODE_TAG('U', 'V', ' ', 'B')
#define UVW_BLOCK_TAG       ENCODE_TAG('U', 'V', 'W', 'B')
#define SPHERE_BLOCK_TAG    ENCODE_TAG('S', 'P', 'H', 'B')

typedef struct {
   unsigned int tag;
   unsigned int length;
} generic_block_header;

typedef struct {
   generic_block_header header;
   unsigned int object_byte_offset;
   unsigned int material_byte_offset;
   unsigned int uv_byte_offset;
   unsigned int uvw_byte_offset;
   unsigned int collision_byte_offset;
   unsigned int extention_byte_offset;
} master_data_block;


typedef struct {
   generic_block_header header;
   unsigned int other_byte_offset[5];
   unsigned int extention_byte_offset;
} extention_data_block;


/* *******************************************************************
******************************************************************* */
class spg2_loader : public spg_loader {

   public:
      // file_loader
      void *extract(unsigned int type, char *altname, int level = 0);

      // spg2_loader
      virtual ~spg2_loader() {}

      int write_data(char *dname, polytype *dob, char *lname, shadelist *lob, char *tname, texpolygon *tob, char *wname, shaderlisttype *wob, char *sname, spheretype *sob);
};


/* *******************************************************************
******************************************************************* */
class spb_loader : public file_loader {

   protected:
      master_data_block mblock;
      
      polytype *ob;
      resource_type *current;

      void extract_shade(shadetype *ilm);
      void write_data(shadetype *ilm);

      void extract_material1();
      void extract_material2();

      void extract_object();
      void extract_material();
      void extract_uv();
      void extract_uvw();
      void extract_colsphere();

      int  calc_size(polytype *data);
      int  calc_size(shadelist *data);
      int  calc_size(texpolygon *data);
      int  calc_size(shaderlisttype *data);
      int  calc_size(spheretype *data);

      void write_data(polytype *data, int size);
      void write_data(shadelist *data, int size);
      void write_data(texpolygon *data, int size);
      void write_data(shaderlisttype *data, int size);
      void write_data(spheretype *data, int size);

      int  write_data(polytype *geom, shadelist *material, texpolygon *uv, shaderlisttype *uvw, spheretype *spheredata, int extension_flag);

   public:
      // basic_loader
      void cleanup();
      basic_loader *find_loader(sfile *data);

      // file_loader
      int read_data();
      void *extract(unsigned int type, char *altname, int level = 0);

      // spb_loader
      spb_loader() { current = NULL; ob = NULL; }
      virtual ~spb_loader() {}

      int write_data(char *filename, polytype *geom, shadelist *material, texpolygon *uv, shaderlisttype *uvw, spheretype *spheredata);
      int write_data(char *filename, polytype **geom, shadelist **material, texpolygon **uv, shaderlisttype **uvw, spheretype **spheredata);
};

#endif

