



#if !defined __SPATCH_H
#define __SPATCH_H

#define SPATPOLY 1
#define SPATREND 2

#define SPDELTA 5

#define vdownrow(x, maxcol) ( (x)+((maxcol)+2) )
#define vuprow(x, maxcol) ( (x)-((maxcol)+2) )
#define vtwo2one(row, col, maxcol) ( ((row)+1)*((maxcol)+2) + ((col)+1) )
#define pdownrow(x, maxcol) ( (x)+((maxcol)-1) )
#define ptwo2one(row, col, maxcol) ( (row)*((maxcol)-1) + (col) )


#include "polygon.h"


/* *************************************************************
************************************************************* */
class spatchtype : public datatype {

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);

      // datatype
      int  read_data(char *filename);

      // spatchtype
      int	vsize, psize;           // vertex/patch count
      int	prow, pcol;
      int	vrow, vcol;             // x, y count
      int	srow, scol;

      vector4f	*data;
      pvector4f	*mvertex;

      vector3f	*ndata;                 // normals for vertex
      pvector3f	*gnormal;

      shadetype	**shade;
      shadetype	***mshade;

      void init();
      void dest();

      spatchtype() { init(); }
      ~spatchtype() { dest(); }

      int build(int crow, int ccol, int nflag, int sflag);
};


/* *************************************************************
************************************************************* */
class spatch : public make_poly {

   protected:
      // pc
      void transform(eye *parm);
      int  clip(eye *parm, int maxx, int maxy);

      // spatch
      spatchtype   *ob;                 // pointer to composite patch data
      spatchtype   *dob;                // pointer to patch data
      texpolygon   *tob;

      camera            *cptr;
      light             *lptr;

      polygon           polyob;
      shaderlisttype    slist;
      spatchtype        ptr;
      texpolygon        ttr;

      int read_data(char *dataname);
      int read_tex(char *filename, char *dfilename);
      int read_3dtex(char *filename, char *dfilename);

      int convert(int i, int j, spatchtype *sob, texpolygon *stob, shaderlisttype *ssob);
      int spline2poly(spatchtype *sob, texpolygon *stob, int xflag);

   public:
   
      // superclass
      int  query_whatami() { return OBJECT_SPATCH; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // frameclass
      int  dump_frame(FILE *outfile);

      // pc
      int  bound_box(eye *parm);
      void bound_sphere();

      void begin_scan() { ob = new spatchtype; tpob = NULL; shadptr = NULL; slist.shade = NULL; }

      void datacopy();
      void end_scan();

      int beamscan(spotlight *spot, engine *proc);
      int scan(camera *cparm, light *lmain, engine *proc);

      void beamrender(spotlight *lmain, engine *proc);
      void prender(engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      // spatch
      string_type filename, texname2;

      virtual ~spatch() {}
};


/* *************************************************************
************************************************************* */
class spatch_loader : public loader {

   public:
      superclass *make_object() { return new spatch; }
      spatch_loader() { object_name = TOKEN_SPATCH_STR; }
      virtual ~spatch_loader() {}
};


#endif

