

#if !defined __SOUNDMAN_H
#define __SOUNDMAN_H

#include "basic_dt.h"
#include "matrix.h"

#define FLAG_MIDI_NULL  0x00
#define FLAG_MIDI_PLAY  0x01

#define FLAG_SOUND_NULL     0x00
#define FLAG_SOUND_WAV      0x01
#define FLAG_SOUND_MIDI     0x02
#define FLAG_SOUND_PLAYING  0x04
#define FLAG_SOUND_LOOPING  0x08
#define FLAG_SOUND_3D       0x10
#define FLAG_SOUND_LOCK     0x20
#define FLAG_SOUND_MUSIC    0x40
#define FLAG_SOUND_VOICE    0x80

#define SOUND_SFX       0
#define SOUND_MUSIC     1
#define SOUND_VOICE     2
#define SOUND_MAX_TYPES 3

#define CHAR2INT( ch0, ch1, ch2, ch3 ) ( ch0 | ( ( ch1 | ( ( ch2 | ( ch3 << 8) ) << 8 ) ) << 8 ) )


/************************************************************************************************
********************************************************************************************** */
class sound_type : public dbl_llist {

   public:
      void *id;
      unsigned int flags;
            
      sound_type() { flags = FLAG_SOUND_NULL; id = NULL; }      
      virtual ~sound_type() {}

      virtual void stop() {}
      virtual void volume(int v) {}
      virtual void update() {}
};


/************************************************************************************************
********************************************************************************************** */
class sound_id_type : public sound_type {

   public:
      void volume(int v) { db = v; }

      string_type name;
      int db;
      
      sound_id_type() { db = 100; }
      virtual ~sound_id_type() {}
};


/************************************************************************************************
********************************************************************************************** */
class sound_midi_type : public sound_type {

   public:
      sound_midi_type() { flags |= FLAG_SOUND_MIDI; }      
      virtual ~sound_midi_type() {}
};


/************************************************************************************************
********************************************************************************************** */
class sound_wav_type : public sound_type {

   public:
      sound_wav_type() { flags |= FLAG_SOUND_WAV; }      
      virtual ~sound_wav_type() {}
};


/************************************************************************************************
********************************************************************************************** */
class sound_wav3d_type : public sound_wav_type {

   protected:
      vector3f position;

   public:
      sound_wav3d_type() { flags |= FLAG_SOUND_3D; position[0] = position[1] = position[2] = 0; }
      virtual ~sound_wav3d_type() {}
       
      virtual void location(float *pos) { copyarray3(position, pos); }
};


/************************************************************************************************
********************************************************************************************** */
class soundman {

   public:
      unsigned int flags;
      vector3i volume;
      
      soundman() { flags = FLAG_SOUND_NULL; volume[0] = volume[1] = volume[2] = 100; }
      virtual ~soundman() {}

      virtual int  init() { return 1; }
      virtual int  dest() { return 1; }
      virtual void reset() {}
      virtual sound_type *play(sound_id_type *sound_id) { return NULL; }
      virtual void update(float *pos, float *dir, float *up) {}
      virtual int  find(sound_id_type *sound_id) { return 0; }
};



#endif

