

#if !defined __SIMMAN_H
#define __SIMMAN_H

#include "gamequrk.h"


#define SIM_INFOBYTE         0x00

#define SIM_OBJECT           0x00

#define SIM_FLAG_NULL        0x00

#define SIM_INFOBYTE_FLAG_NULL        0x00
#define SIM_INFOBYTE_FLAG_SUCCESS     0x01
#define SIM_INFOBYTE_FLAG_FAILURE     0x02
#define SIM_INFOBYTE_FLAG_REDUNDANT   0x03

#define SIM_INFOFLAG_DYNAMIC_TASK          0x00000001
#define SIM_INFOFLAG_SOURCE                0x00000002
#define SIM_INFOFLAG_RESCIND_DYNAMIC_TASKS 0x00000003

#define SIM_MANAGER_EVENT 0
#define SIM_MANAGER_INFO  1
#define SIM_MANAGER_TASK  2
#define SIM_MANAGER_MAX   3


class sim_infobyte_type;

/* *************************************************************
************************************************************* */
class sim_object : public dbl_llist {

   protected:
      void clear_dynamic_tasks(sim_object *source);

   public:
      unsigned int flags;
      dbl_llist_manager script_manager[SIM_MANAGER_MAX];
      dbl_llist_manager success_manager;
      atom_list_type *owner;
      sim_object *parent;

      sim_object() { flags = SIM_FLAG_NULL; owner = NULL; parent = NULL; }
      virtual ~sim_object() {}

      sim_infobyte_type *find_infobyte(int type, int fid);

      virtual int query_whatami()  { return SIM_OBJECT; }
      virtual int query_whatwasi(int type);

      virtual int parse(FILE *infile, char *token);
      virtual void preprocess(void *data);
      virtual void process_ai();
      virtual void render2d(mapul *mapbuffer);
    
      virtual sim_infobyte_type *process_info(FILE *infile, char *token) { return NULL; }
      virtual sim_infobyte_type *process_task(FILE *infile, char *token) { return NULL; }
      virtual sim_infobyte_type *process_event(FILE *infile, char *token) { return NULL; }

      virtual int set_specific_data(int type, void *data);
      virtual int query_specific_data(int type, void *data) { return 0; }
};


/* *************************************************************
************************************************************* */
class sim_object_list : public dbl_llist {

   public:
      sim_object *ob;
      
      sim_object_list () { ob = NULL;}
      virtual ~sim_object_list() {}
};


typedef struct {
   sim_object *head, *parent;
} sim_preprocess_type;


/* *************************************************************
************************************************************* */
class sim_infobyte_type : public dbl_llist {

   public:
      sim_object *owner;
      int id, priority;
      unsigned int flags;

      sim_infobyte_type() { id = -1; priority = 0; owner = NULL; flags = SIM_INFOBYTE_FLAG_NULL; }
      virtual ~sim_infobyte_type() {};
         
      virtual int query_whatami()  { return SIM_INFOBYTE; }
      virtual int query_class() { return SIM_MANAGER_INFO; }

      virtual int parse(FILE *infile, char *token);
      virtual void preprocess(void *data);
      virtual int update() { return 0; }
      virtual void render2d(mapul *mapbuffer) {}
      virtual sim_infobyte_type *find_subinfobyte(int type, int fid) { return NULL; }

      virtual int set_specific_data(int type, void *data) { return 0; }
      virtual int query_specific_data(int type, void *data) { return 0; }
};


/* *************************************************************
************************************************************* */
class sim_event_type : public sim_infobyte_type {

   public:
      int query_class() { return SIM_MANAGER_EVENT; }

      void preprocess(void *data) { sim_infobyte_type::preprocess(data); }

      virtual ~sim_event_type() {}
};


/* *************************************************************
************************************************************* */
class sim_task_type : public sim_infobyte_type {

   public:
      int query_class() { return SIM_MANAGER_TASK; }

      void preprocess(void *data);

      virtual ~sim_task_type() {}

      virtual int query_priority() = 0;
      virtual void get_status(string_type *token) = 0;
};


/* *************************************************************
************************************************************* */
class sim_task_node : public dbl_llist {

   public:
      sim_task_type *node;
      
      virtual ~sim_task_node() {}
};


#endif
