

/* *************************************************************
   This file contains all the global data types for my programs
************************************************************* */

#if !defined (__SHADING_H)
#define __SHADING_H

#include "superclass.h"
#include "matrix.h"


#define NEW_ILM_TAG "ILM2"


/* *************************************************************
************************************************************* */
class shadetype {

   public:
      vector3i ka, kp, ks, lum;
      vector3f fka, fkp, fks, flum;
      float specn;                        // power of cosine

      shadetype();
      virtual ~shadetype() {}
      void read_data(FILE *infile);
      int  write_data(FILE *outfile);
      int  matcmp(shadetype *x);
      void update_float();
      void update_int();
};

typedef shadetype * pshadetype;
typedef shadetype ** ppshadetype;


/* *************************************************************
************************************************************* */
class texcolortype {

   public:
      shadetype color;
      vector3f  ambient;

      void set(shadetype *x);
};


/* *************************************************************
************************************************************* */
class shade_block {

   public:
      int shade_count;
      shadetype *shade_palette;

      int index_count;
      int *index_palette;

      shadetype **facelist;

      shade_block();
      virtual ~shade_block();
};


/* *************************************************************
// Note: "next" deleted by "frame_manager"
************************************************************* */
class shadelist : public resource_type {

   protected:
      shade_block *sblock;

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);
   
      shadetype base;
      int maxfacecount;

      shadelist();
      shadelist(int fcount);
      virtual ~shadelist();

      int read_data(char *filename, int facecount);
      void postprocess(int facecount);
      int write_data(char *filename);
};


#endif

