

#include "base.h"


#if !defined __SHADER_H
#define __SHADER_H


class pc;


typedef enum {

   SURFACE    = 0,
   ATMOSPHERE = 1,
   DISPLACEMENT = 2
} shader_type;


/* *************************************************************************
// backwards compatible w/ older code
************************************************************************* */
class shaderparamtype {

   public:
      vector4f in;              // pt in local coordinates
      vector4f normal;          // normal in world coordinates
      vector4f pt;              // pt in world coordinates (out)
      vector4f xform[4], ixform[4];
      int   frame;

      eye    *cam;
      pc     *ob;

      fractal_params params;
      float min, max;

      vector3f out;             // out color
      vector3f add;             // out additional color

      shaderparamtype();
      virtual ~shaderparamtype() {}
      
      void setup(vector4f *xf, vector4f *ixf, int f, eye *c, pc *o, float fscale);
      void set_point(float *local, float *n);
};


/* *************************************************************************
 backwards compatible w/ older code
************************************************************************* */
class shader : public doer {

   public:
      virtual ~shader() {}
};

typedef shader *pshader;

/* *************************************************************************
************************************************************************* */
class shadertype {

   public:
      shader **s;
      shader_type *stype;

      int scount;

      shadertype() { s = NULL; stype = NULL; scount = 0; }
      virtual ~shadertype() { if (s) delete [] s; if (stype) delete [] stype; }
      void read_data(FILE *infile, binary_tree *sptr);

      shadertype &operator = (shadertype &x);
};


/* *************************************************************************
************************************************************************* */
class shaderlisttype : public resource_type {

   public:
      shadertype        *shade;
      float             scale;
      int               scount;

      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);

      shaderlisttype() { shade = NULL; scale = 1; }
      virtual ~shaderlisttype() { if (shade) delete [] shade; }

      void init(int x);
};


#endif

