

#if !defined __SBFAST_H
#define __SBFAST_H


#include "base.h"


/* ****************************************************************
**************************************************************** */
class sbmap {

   public:
      texbase  *ob;
      int      repeatflag;
      float    xscale, yscale;
      fixed_pt fxpxscale, fxpyscale;
      float    min[2], max[2];
      fixed_pt fxpmin[2], fxpmax[2];

      int      flaginv;
      float    xsign, ysign;
      float    area;

      void     setup(vector4f *pt);
      unsigned int query_texel(float x, float y, float *c, int frame, float d);
};


/* *************************************************************
************************************************************* */
class texsbfast : public resource_type {

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);

      // texsbfast
      int   countobject;
      sbmap *data;

      texsbfast() { data = NULL; }
      virtual ~texsbfast() { if (data) delete [] data; }

      void setup(int x);
      int query_texel(float x, float y, float *c, int frame, float d);
};


/* *************************************************************
        sbuffer -
                        0:      not done
                        1:      done and hit
                        2:      done and no hit
                        4:      dither
************************************************************* */
class sbfast : public pc {

   protected:
   
      // pc
      void transform(eye *parm);
      int clip(eye *parm, int maxx, int maxy) { return 0; }

      // sbfast
      float   master_back, back;        // max distance from camera
      fractal_params params;

      shaderparamtype dis;

      vector4f old_pos;
      int   start_flag;

      string_type shadername;
      shader  *displacement;

      float   isize;
      char    ditherflag;

      texsbfast *tob;
      mapuc *sbbuffer;

      int  read_tex(char *filename);
      int  read_3dtex(char *filename);

      float Intersect_Surface(float distance, float increment,
                      float *cam, float *ray, float *surface, float *normal);
      int Intersect_Terrain(float increment, float *cam, float *ray,
                      float *surface, float *normal);

      void sbfastpg_vertical(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int dflag);
      void sbfastpg_horizontal(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int dflag);

      void sbfastpg_llurh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy);
      void sbfastpg_llurv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx);

      void sbfastpg_urllh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy);
      void sbfastpg_urllv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx);

      void sbfastpg_ullrv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx);
      void sbfastpg_ullrh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy);

      void sbfastpg_lrulv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx);
      void sbfastpg_lrulh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy);

      void sbfastpg_verticald(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int midy);
      void sbfastpg_horizontald(eye *parm, light *lmain, light *spot, zbuffer *zbuff, int midx);

      void sbfastpg_posv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx, float *up, float *horizon);
      void sbfastpg_posh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy, float *up, float *horizon);

      void sbfastpg_negv(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dx, float *up, float *horizon);
      void sbfastpg_negh(eye *parm, light *lmain, light *spot, zbuffer *zbuff, float dy, float *up, float *horizon);

//      void sbfastpg_postscan(zbuffer *zbuff);
      void dither(zbuffer *zbuff);

      void sbfastbm_vertical(spotlight *spot, int dflag);
      void sbfastbm_horizontal(spotlight *spot, int dflag);

      void sbfastbm_llurh(spotlight *spot, float dy);
      void sbfastbm_llurv(spotlight *spot, float dx);

      void sbfastbm_urllh(spotlight *spot, float dy);
      void sbfastbm_urllv(spotlight *spot, float dx);

      void sbfastbm_ullrv(spotlight *spot, float dx);
      void sbfastbm_ullrh(spotlight *spot, float dy);

      void sbfastbm_lrulv(spotlight *spot, float dx);
      void sbfastbm_lrulh(spotlight *spot, float dy);

      void sbfastbm_verticald(spotlight *spot, int midy);
      void sbfastbm_horizontald(spotlight *spot, int midx);

      void sbfastbm_posv(spotlight *spot, float dx, float *up, float *horizon);
      void sbfastbm_posh(spotlight *spot, float dy, float *up, float *horizon);

      void sbfastbm_negv(spotlight *spot, float dx, float *up, float *horizon);
      void sbfastbm_negh(spotlight *spot, float dy, float *up, float *horizon);

      void sbfastbm_postscan(spotlight *spot);

   public:
   
      // superclass
      int  query_whatami() { return OBJECT_SBFAST; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      int  dump_frame(FILE *outfile);
      
      // pc
      int  bound_box(eye *parm);
      void bound_sphere();

      void begin_scan();
      void end_scan();

      void datacopy();

      int beamscan(spotlight *spot, engine *proc);
      int scan(camera *cparm, light *lmain, engine *proc);

      void beamrender(spotlight *spot, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);
      void prender(engine *proc);

      // sbfast
      string_type texname2;

      sbfast();
      virtual ~sbfast() {}

      float query_octaves() { return params.octaves; }
};


/* *************************************************************
************************************************************* */
class sbfast_loader : public loader {

   protected:
      superclass *make_object() { return new sbfast; }

   public:
      sbfast_loader() { object_name = TOKEN_SBFAST_STR; }
      virtual ~sbfast_loader() {}
};



#endif

