

#if !defined __POLYTYPE_H
#define __POLYTYPE_H


#include "datatype.h"


typedef struct {
   float    iarea;
   int      polynum;
   vector4f normal;
   int      *edgeptr;
   vector3f color;
   vector3f ambient;
} face_type;


/* *************************************************************
************************************************************* */
class polygon_object_type {

   public:
      vector4f  *vlist;
      vector3f  *nlist;

      face_type *flist;
      int       *vindex;

      void dest();

      polygon_object_type();
      virtual ~polygon_object_type() { dest(); }

      int build(int cvertex, int cobject, int cedge);
};


/* *************************************************************
************************************************************* */
class polytype : public datatype {              // composite data

   protected:
      polygon_object_type *polygon_data;

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);

      // datatype
      int  read_data(char *filename);

      // polytype
      int countvertex;       // vertex count
      int countedge;	     // edge count
      int countobject;       // polygon count

      int maxpolynum;

      void init();
      void dest();

      polytype() { init(); }
      virtual ~polytype() { dest(); }

      int write_data(char *filename);
      int build(int cvertex, int cobject, int cedge);
      void preprocess();
      void calc_normal();
      void calc_area();
      void calc_vnormal();
      void vtransform(vector4f *mx);
      void ntransform(vector4f *mx);
      void vntransform(vector4f *mx);
      void scale_area(float scale);
};


/* *************************************************************
************************************************************* */
class texface {

   public:
      texbase  *ob;
      vector2f *uv;
      int      count;
      float    area;

      texface();
      virtual ~texface();

      void setup(int i);
      void calc_area();
      void make_unit();
      int  write_coord(FILE *outfile);
      int  write_basis(FILE *outfile);
};


/* *************************************************************
************************************************************* */
class texpolygon : public resource_type {

   protected:
      texface *data;

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      int  query_data(int type, void *key, void *response) { return resource_type::query_data(type, key, response); }
      void replace_data(void *subresource);

      // texpolygon
      int countobject;

      texpolygon() { data = NULL; }
      texpolygon(int i) : resource_type() { data = new texface[i]; }

      virtual ~texpolygon();

      int query_tflag(int i) { return (data[i].ob != NULL); }
      void query_uvmap(int i, int j, float *uv) { copyarray2(uv, data[i].uv[j]); }

      void setup(int i);
      unsigned int query_texel(int face, float x, float y, float *color, int frame, float d);

      int query_data(int face, int type, void *key, void *response) { return data[face].ob ? data[face].ob->query_data(type, key, response) : 0; }

      void perim2Dmap(int face, int *corner, texbase *tob, polytype *dob);
      void direct2Dmap(int face, vector2f *uv, texbase *tob, int vcount, int unitflag);
      void affinemap(int face, vector2f *uv, texbase *tob, polytype *dob, int unitflag);

      int read_data(char *filename, polytype *dob);
      int write_coord(char *filename);
      int write_basis(char *filename);
};


#endif
