

#if !defined __POLYOPS_H
#define __POLYOPS_H


#include "polytype.h"
#include "shading.h"

#include "sphrtype.h"
#include "texture.h"


#define	EC_FAIL         0
#define EC_TWO_VERTICES 1
#define EC_T2P1_P2T     2
#define EC_T2P1_T1P     3
#define EC_T1P2_P1T     4
#define	EC_T1P2_T2P     5
#define EC_T_IN_P       6
#define EC_P_IN_T       7

#define OVERRIDE        0
#define CHECK_NORMAL    1


/* **************************************************************
************************************************************** */
class vertex_type : public circular_dbl_llist {

   public:
      int      vertex_index;
      vector3f normal;
      vector2f uv;
      int      concaveflag;        // flag if vertex is "concave"

      vertex_type() { concaveflag = 0; }
      virtual ~vertex_type() {}
      
      void copy(vertex_type *x);
      int vsimilar(vertex_type *x, int texflag);
      int query_between(int i, vector3f *verts);
};


/* **************************************************************
************************************************************** */
class vertex_manager : public circular_dbl_llist_manager {

   public:
      circular_dbl_llist *append(circular_dbl_llist *x, circular_dbl_llist *target=NULL);
      circular_dbl_llist *insert(circular_dbl_llist *x, circular_dbl_llist *target=NULL);

      vertex_type *find(int x);
      int find(vertex_type *x);
      void clone_list(vertex_manager *vman);

      void affinemap(vector2f *uv, vector3f *verts);
      void calc_uv(vector3f *verts);
      int  calc_vnormal(vector3f *verts);
      int  validate(vector3f *verts);
      void triangle(vertex_type *btr, vertex_type *ptr, vertex_type *ntr);
      
      virtual ~vertex_manager() {}
};


/* **************************************************************
************************************************************** */
class face_work_type : public dbl_llist {

   protected:
      int edge_intersect_edge(float *start, float *end, float *pt1, float *pt2, float *intersect);
      int query_combine_line(vector3f *verts, vertex_type *v1, vertex_type *v2, vertex_type *v3, int texflag, float angle);

   public:
      vector4f face_normal;   // normal and A,B,C,D of the planar equation
      int material_index;
      int textureflag;

      vertex_manager vlist;

      face_work_type() { textureflag = material_index = 0; }
      virtual ~face_work_type() {}
      
      int  calc_concave();
      void affinemap(vector2f *uv, vector3f *verts);

      int  remove_backtrack(vector3f *verts, float angle);
      void post_smash(vector3f *verts, int btflag);

      int  query_pt_in_polygon(float *pt, vector3f *verts);
      int  query_internal_diagonal(vector3f *verts, vertex_type *pt1, vertex_type *pt2);
      face_work_type *make_subface(vertex_type *vtr, vertex_type *wtr, vector3f *verts, int orders);

      void triangulate(vector3f *verts, dbl_llist_manager *triman);
};


typedef face_work_type *pface_work_type;


/* **************************************************************
   used to sort and remove similar verticies
************************************************************** */
class vbdata : public binary_data {

   public:
      int compare(binary_data *x);

      // key
      vector3f v;
      unsigned int id;

      virtual ~vbdata() {}
      
      void build(vector3f *x);
};


/* **************************************************************
************************************************************** */
class vbnode : public binary_node {

   public:
      virtual ~vbnode() {}
      void build(vector3f *x);
};


/* **************************************************************
************************************************************** */
class vbtree : public binary_tree {

   public:
      virtual ~vbtree() {}
      void build(vector3f *x);
};


/* **************************************************************
************************************************************** */
class mtllist {

   public:
      int id;
      shadetype ilm;
      string_type texname;  // NOTE: only set/used for importing...

      // used for find() only! mtllist is allocated as arrays
      mtllist *next;
      
      mtllist() { id = 0; ilm.specn = 2.0f; next = NULL; }
      virtual ~mtllist() {}
      
      int insert(mtllist *x);
      int find(int x, mtllist **y = NULL);
      int mtlcmp(mtllist *x);
};


/* **************************************************************
************************************************************** */
class group_type : public dbl_llist {

   public:
      dbl_llist_manager flist;  // face_work_type
      vector4f group_normal;	// normal/planar coefficients
      int material_index;
      int textureflag;

      virtual ~group_type() {}
      
      void mega_insert_btree(vector3f *verts, face_work_type *x);
      void material_insert_btree(mtllist *mtl, face_work_type *x);
      void build_list(dbl_llist_manager *head);
};


/* **************************************************************
************************************************************** */
class edge_match_type : public dbl_llist {

   public:
      vertex_type *v11, *v12, *v21, *v22;
      float probability;
      int resultflag;

      edge_match_type(vertex_type *v1, vertex_type *v2, vertex_type *v3, vertex_type *v4, int r, float p) {

         v11 = v1;
         v12 = v2;
         v21 = v3;
         v22 = v4;
         resultflag = r;
         probability = p;
      }

      virtual ~edge_match_type() { }
};


/* **************************************************************
************************************************************** */
class edge_match_list : public dbl_llist {

   public:
      face_work_type *candidate;
      dbl_llist_manager stats;

      edge_match_list(dbl_llist_manager *match, face_work_type *face);

      virtual ~edge_match_list() { }
};


/* **************************************************************
************************************************************** */
class optimizer {

   protected:
      void build_optimized_vertexlist();

      void calc_height_split(float *res, float *a, float *b, float *c);
      void calc_bisect_split(float *res, float *a, float *b, float *c);

      int ray_intersect_edge(float *start, float *ray, float *pt1, float *pt2, float *intersect);
      int query_mesh_uv(float *p1, float *p2, float plength, float *t1, float *t2, float tlength, float *test);
      int query_subset_edge(vertex_type *p1, vertex_type *p2, vertex_type *t1, vertex_type *t2, int textureflag, float *p);

      int recurse_crack_face(face_work_type *new_face, dbl_llist_manager *solution);
      int recurse_split_face(face_work_type *new_face, dbl_llist_manager *solution);

      int break_face(face_work_type *face, dbl_llist_manager *solution);
      int crack_face(face_work_type *face, dbl_llist_manager *solution);
      int split_face(face_work_type *face, dbl_llist_manager *solution);

      void query_combine(face_work_type *face1, face_work_type *face2, dbl_llist_manager *out);
      int  remove_edge(int matchcount, edge_match_list *emlpresident, dbl_llist_manager *flist, face_work_type *ftr, vector3f *vertex_data, int *overlap_count);
      int  smash_edge(edge_match_list *emlpresident, dbl_llist_manager *flist, face_work_type *ftr, vector3f *vertex_data, int *overlap_count);
      void join_face(face_work_type *poly, vertex_type *polystart, vertex_type *polyend, face_work_type *triangle, vertex_type *tristart, vertex_type *triend);
      int  split_weak_link(face_work_type *face, dbl_llist_manager *fman);
      int  combine_2_triangles(group_type *group, int *overlap_count);
      
      int  decimate(face_work_type *face);
      void simple(dbl_llist_manager *groupman);
      void complex(dbl_llist_manager *groupman, int *overlap_count);

   public:
      int vertexcount;
// asdf whats really needed is a vertex pool - so dont have to allocate mega-amounts at start (X16)
      vector3f *vertex_data;

      dbl_llist_manager final_face_data;

      optimizer();
      virtual ~optimizer();

      void optimize_geometry(mtllist *mtl, int aggressive_flag, int spike_flag, int optimize_flag);
};


/* **************************************************************
************************************************************** */
class virtual_object {

   public:
      optimizer *optimize;
      
      virtual_object() { optimize = NULL; }
      virtual ~virtual_object() { if (optimize) delete optimize; }

      int build_triangle_list(dbl_llist_manager *faceman);
      
      virtual void init();
};


/* **************************************************************
************************************************************** */
class SPXobject : public virtual_object {

   protected:
      virtual int build_texture_list();

   public:

      // virtual_object
      void init();

      // SPXobject
      mtllist *shade;
      int shade_count;

//asdf should work - problem w/ destructors when dealing w/ a dynamic array of "texture"
//      texbase *texture_list;
      texture *texture_list;
      int texture_count;
      
      SPXobject();
      virtual ~SPXobject();

      virtual int postprocess_uv();

      spheretype *Build_COL(polytype *ob);
      polytype   *Build_SPG();
      shadelist  *Build_ILM();
      texpolygon *Build_TEX(polytype *ob);

      int Import_SPG(polytype *ob);
      int Import_TEX(texpolygon *tob);
      int Import_ILM(shadelist *lob, int countobject);
};


int write_spg(char *basename, SPXobject *spxob);
int read_spg(char *basename, SPXobject *spxob);
int write_spb(char *basename, SPXobject *spxob);
int read_spb(char *basename, SPXobject *spxob);

int query_calc_normal(float *a, float *b, float *c);
int query_spike(vector3f *verts, vertex_type *v1, vertex_type *v2, vertex_type *v3, int texflag, float angle);

extern float COS_FIVE_DEG;
extern float MIN_POLY_AREA;
extern int gtex;
extern int gilm;
extern int gcol;

#endif





