

#if !defined __POLYGON_H
#define __POLYGON_H


#include "base.h"
#include "polytype.h"

#define POLYFLAG_NULL           0
#define POLYFLAG_BACKFACE_CULL	1
#define POLYFLAG_TRANSFORM      2
#define POLYFLAG_BOUNDBOX       4

#define BUCKETSIZE              256

/* *************************************************************
        prenum = parm->imscale*normal[0]
        prediv = v[0]*normal[0] + v[1]*normal[1] - normal[2];
************************************************************* */
#define perspect_dx(normal, prenum, prediv, t)    \
   prediv += prenum;                    \
   t = (fabs(prediv) > CORRECT) ? normal[3]/prediv : back;

/* *************************************************************
        FAR: prenum = -parm->imscale*normal[0]/normal[2]
             prediv = previous "t"
************************************************************* */
#define fperspect_dx(prenum, prediv, t)      \
   prediv += prenum;                    \
   t = prediv;

#define FLAG_RAYCAST       0
#define FLAG_2D            1
#define FLAG_3D            2
#define FLAG_TRANS         3
#define FLAG_OVERWRITE     4
#define FLAG_GHOST         5
#define FLAG_BEAM          6
#define FLAG_BIPLANE       7
#define FLAG_T             8
#define FLAG_BT            9
#define FLAG_MAX          16

#define COMMON_SPOT             \
        int i;                  \
        edgetype *ptr, *qtr;    \
        edgetype *aet;          \
        int scany, scanxy;      \
        float scanfy;           \
        int index, start, end;  \
        vector4f surface;       \
        int winx, winy;         \
        float mz, mdz;          \
        memman  *control = proc->control;          \
        char bitflags[FLAG_MAX] = {                \
           (mcinfo.info & CIRAYCAST) == CIRAYCAST, \
           0, \
           0, \
           0, \
           0, \
           0, \
           0, \
           0, \
           0, 0, 0, 0, 0, 0, 0, 0   \
        };  \
        float  prenum, prediv;      \
                                    \
        surface[3] = 1

#define COMMON_WFBW             \
        int i;                  \
        edgetype *ptr;    \
        int scany, scanxy;      \
        int index, end;  \
        int winx;         \
        float mz, mdz;          \
        zbuffer *zbuff   = &proc->zbuff;                        \
        memman  *control = proc->control;                       \
        char bitflags[FLAG_MAX] = {                             \
           0,              \
           0,              \
           0,                  \
           0,      \
           (mcinfo.info & CIOVERWRITE) == CIOVERWRITE,          \
           (mcinfo.info & CIGHOST)  == CIGHOST,                 \
           0,    \
           0, \
           0, 0, 0, 0, 0, 0, 0, 0 \
        }

#define COMMON                  \
        int i;                  \
        edgetype *ptr, *qtr;    \
        edgetype *aet;          \
        int scany, scanxy;      \
        float scanfy;           \
        int index, start, end;  \
        vector4f surface;       \
        int winx, winy;         \
        float mz, mdz;          \
        zbuffer *zbuff   = &proc->zbuff;                        \
        memman  *control = proc->control;                       \
        char bitflags[FLAG_MAX] = {                             \
           (mcinfo.info & CIRAYCAST) == CIRAYCAST,              \
           (mcinfo.info & CITEXTURE) == CITEXTURE,              \
           (mcinfo.info & CI3DTEX) == CI3DTEX,                  \
           (mcinfo.info & CITRANSPARENT) == CITRANSPARENT,      \
           (mcinfo.info & CIOVERWRITE) == CIOVERWRITE,          \
           (mcinfo.info & CIGHOST)  == CIGHOST,                 \
           spot && !(mcinfo.info & CITRANSPARENT),    \
           (mcinfo.info & CITEXTURE) == CITEXTURE && (mcinfo.info & CIINVISO) == CIINVISO, \
           0, 0, 0, 0, 0, 0, 0, 0 \
        };  \
        float  prenum, prediv;      \
                                    \
        surface[3] = 1


class shadow;


/* *************************************************************
   object to render poligonal data.
************************************************************* */
class polygon : public pc {

   friend class shadow;

   protected:
   
      // pc
      int clip(eye *parm, int maxx, int maxy);          // use polyclet instead
      void transform(eye *parm);
      
      // polygon

      polytype   *dob;                                  // pointer to data
      texpolygon *tob;
      edgetype   **et;                                  // temporary - constructor/destructor not set

      polygon_object_type *pot;
      shade_block *sblock;
      texface *uvblock;

      // polyfile
      int read_3dtex(char *filename, char *dfilename);

      // polyclet
      pointlisttype *split_edge(pointtype *start, pointtype *end, int i, float plane, float *normal, eye *parm, memman *control, int texture_flag);
      void clip_greater(pointlisttype **ptr, int i, float  plane, float *normal, eye *parm, memman *control, int texture_flag);
      void clip_lesser(pointlisttype **ptr, int i, float  plane, float *normal, eye *parm, memman *control, int texture_flag);

      void add_edge_table_bw(engine *proc, eye *parm);
      void add_edge_table_all(engine *proc, eye *parm, light *lmain);

      int polyclet(eye *parm, light *lmain, int maxx, int maxy, engine *proc);

      virtual pointlisttype *edgelist(eye *parm, light *lmain, int i, int texture_flag, memman *control);
      virtual void prepare_edge(engine *proc, int face, pointtype *start, pointtype *end, int starty, int endy, int texture_flag);
      virtual void prepare_hedge(engine *proc, int face, pointtype *start, pointtype *end, int starty);

      // polyform
      void removeside(eye *parm);

      // polyshad
      void sortbucket(edgetype **head, edgetype *node);
      void fixed_sortbucket(edgetype **head, edgetype *node);

      void  constcolor(eye *parm, light *lmain);
      float perspect(float *normal, float *middle, eye *parm, float *prenum, float *prediv);

      void polylt(spotlight *parm, engine *proc);

      void polywfbw(light *spot, engine *proc);
      void polybw(eye *parm, light *spot, engine *proc);

      void polyct(eye *parm, light *spot, engine *proc);
      void polyct(engine *proc);
      void polyct2(engine *proc);

      void polygd(eye *parm, light *spot, engine *proc);
      void polyal(eye *parm, light *lmain, light *spot, engine *proc);
      void polypg(eye *parm, light *lmain, light *spot, engine *proc);

   public:

      // superclass
      int query_whatami() { return OBJECT_POLYGON; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      
      // frameclass
      int  dump_frame(FILE *outfile);

      // pc
      int  bound_box(eye *parm);
      void bound_sphere();
      void datacopy();
      void begin_scan();
      void end_scan();

      int  beamscan(spotlight *spot, engine *proc);
      int  scan(camera *cparm, light *lmain, engine *proc);

      void beamrender(spotlight *spot, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);
      void prender(engine *proc);

      // polygon
      string_type filename, texname2;
      polytype *ob;                     // pointer to composite data
      unsigned int inviso;
      int polyflag;                     // flags for rendering stages

      polygon() { dob = ob = NULL; polyflag = 0; }
      virtual ~polygon() {}

      polytype *get_render_object() { return dob; }

      void setup_patch(polytype *sob, shadelist *slob, colortype sctype, unsigned int scinfo,
                       int sid, int ssflag, float  ssplane[], float sworld[][4], float siworld[][4], float  box[][4], shadetype *c);
      void setup_texture(texpolygon *stob);
      void setup_texture3d(shaderlisttype *stob);
};



/* *************************************************************
   object to render poligonal data.
************************************************************* */
class shadow : public polygon {

   protected:
							// shadow
      void object2plane(camera *cparm, light *lmain);
      void shadct(eye *parm, light *spot, engine *proc);

   public:
							// superclass
      int parse(FILE *infile, char *token) { return polygon::parse(infile, token); }
      void preprocess(void *data) { polygon::preprocess(data); }
							// shadow
      int  datacopy2(polygon *pob, camera *cparm, light *lmain);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      virtual ~shadow() {}
};


/* *************************************************************
************************************************************* */
class polygon_loader : public loader {

   protected:
      superclass *make_object() { return new polygon; }

   public:
      polygon_loader() { object_name = TOKEN_POLYGON_STR; }
      virtual ~polygon_loader() {}
};


/* *************************************************************
************************************************************* */
class make_poly : public pc {

   protected:
                                // make_poly
      polytype     *pob;
      shadelist    *plob;
      texpolygon   *tpob;

      void setup_transfer(int vcount, int pcount);

   public:
      int parse(FILE *infile, char *token) { return pc::parse(infile, token); }
      void preprocess(void *data) { pc::preprocess(data); }

      virtual ~make_poly() {}
};


#endif

