

#if !defined __POLYGAME_H
#define __POLYGAME_H


#include "gamequrk.h"
#include "glpolygon.h"


/* *************************************************************
   object to render poligonal data.
************************************************************* */
class polygame : public polygon {

   protected:
      void prepare_edge(engine *proc, int face, pointtype *start, pointtype *end, int starty, int endy, int texture_flag);
      pointlisttype *edgelist(eye *parm, light *lmain, int i, int texture_flag, memman *control);

      void game_0x00(eye *parm, engine *proc, int face);
      void game_0x01(eye *parm, engine *proc, int face);
      void game_0x02(eye *parm, engine *proc, int face);
      void game_0x03(eye *parm, engine *proc, int face);
      void game_0x04(eye *parm, engine *proc, int face);
      void game_0x05(eye *parm, engine *proc, int face);
      void game_0x08(eye *parm, engine *proc, int face);
      void game_0x09(eye *parm, engine *proc, int face);
      void game_0x0a(eye *parm, engine *proc, int face);
      void game_0x0b(eye *parm, engine *proc, int face);
      void game_0x0c(eye *parm, engine *proc, int face);
      void game_0x0d(eye *parm, engine *proc, int face);

      void gametex_0x00(eye *parm, engine *proc, int face);
      void gametex_0x01(eye *parm, engine *proc, int face);
      void gametex_0x02(eye *parm, engine *proc, int face);
      void gametex_0x03(eye *parm, engine *proc, int face);
      void gametex_0x04(eye *parm, engine *proc, int face);
      void gametex_0x05(eye *parm, engine *proc, int face);
      void gametex_0x08(eye *parm, engine *proc, int face);
      void gametex_0x09(eye *parm, engine *proc, int face);
      void gametex_0x0a(eye *parm, engine *proc, int face);
      void gametex_0x0b(eye *parm, engine *proc, int face);
      void gametex_0x0c(eye *parm, engine *proc, int face);
      void gametex_0x0d(eye *parm, engine *proc, int face);

   public:

      // superclass
      void preprocess(void *data);

      // pc
      void datacopy();
      int scan(camera *cparm, light *lmain, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      // polygame
      float last_frame;
      
      virtual ~polygame() {}
};


/* *************************************************************
************************************************************* */
class fxpolygame : public polygame {

   public:
      // superclass
      int  query_whatami() { return OBJECT_FXPOLYGON; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // pc
      int scan(camera *cparm, light *lmain, engine *proc);

      // fxpolygame
      virtual ~fxpolygame() {}
      
      void set_ob_data(polytype *fxdob, shadelist *fxlob, texpolygon *fxtob, unsigned int shade, unsigned int flags);
};


/* *************************************************************
   object to render poligonal data.
************************************************************* */
class glpolygame : public glpolygon {

   protected:
      // gl_poly
      void render_material();

   public:
      // superclass
      void preprocess(void *data);

      // pc
      int scan(camera *cparm, light *lmain, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      // glpolygame
      float last_frame;
      
      virtual ~glpolygame() {}
};


/* *************************************************************
************************************************************* */
class glfxpolygame : public glpolygame {

   public:
      // superclass
      void preprocess(void *data);

      // pc
      int scan(camera *cparm, light *lmain, engine *proc);

      // fxpolygame
      virtual ~glfxpolygame() {}

      void set_ob_data(polytype *fxdob, shadelist *fxlob, texpolygon *fxtob, unsigned int shade, unsigned int flags);
};


#endif

