

#if !defined (__PHOTON_H)
#define __PHOTON_H

#include "quark.h"


/* *************************************************************
   This is the lighting class
************************************************************* */
class photon : public quark {

   protected:
      vector3f Ia, Ip, fatt;
      int fattflag;
      float distance2plane, length, width;
      string_type texname;
      vector3f  vpn, vup;

   public:
      // superclass
      int  query_whatami() { return OBJECT_PHOTON; }
      int query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void setup();

      // photon
      photon();
      virtual ~photon() {}
};


/* *************************************************************
************************************************************* */
class photon_loader : public quark_loader {

   public:
      superclass *make_object() { return new photon; }
      photon_loader() {
         object_name = TOKEN_PHOTON_STR;
         alias_name = TOKEN_LIGHT_STR;
      }

      virtual ~photon_loader() {}
};


#endif

