

#if !defined __PCLOUD_H
#define __PCLOUD_H

#include "base.h"
#include "gamequrk.h"

#define FLAG_PARTICULATE_NULL    0x00
#define FLAG_PARTICULATE_VISIBLE 0x01


typedef struct {
   vector4f pos;
   vector4uc color;
} particulate;

typedef struct {
   vector2i pt;
   float iz;
   unsigned int flags;
} work_particulate;

   
/* *************************************************************
   This is the base class for objects to be rendered by the system
************************************************************* */
class pcloud : public pc {

   protected:
      int clip(eye *parm, int maxx, int maxy) { return 1; }
      void transform(eye *parm) {}
      int bound_box(eye *parm) { return 1; }
      
   public:
      // superclass
      int  query_whatami() { return OBJECT_PARTICLE_CLOUD; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // pc
      void bound_sphere();

      void begin_scan();
      void end_scan();
      void datacopy() {}

      int scan(camera *cparm, light *lmain, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      int beamscan(spotlight *spot, engine *proc) { return 0; }

      void beamrender(spotlight *spot, engine *proc) {}
      void prender(engine *proc) {}

      // pcloud
      int count;
      particulate *cloud;
      work_particulate *wcloud;
      unsigned int recalc_bound_flag;
      vector4f local_bcenter;
      float local_bradius2;
      
      pcloud() { cloud = NULL; wcloud = NULL; recalc_bound_flag = 1; }
      virtual ~pcloud() { if (cloud) delete [] cloud; if (wcloud) delete [] wcloud; }
};


/* *************************************************************
************************************************************* */
class glpcloud : public pcloud {

   public:
      // pc
      int scan(camera *cparm, light *lmain, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);
      void begin_scan() {}
      void end_scan() {}

      virtual ~glpcloud() {}
};


#endif

