#if !defined __PARTICLE_H
#define __PARTICLE_H

#include "base.h"

class shadowpt;

/* *************************************************************
************************************************************* */
class particle : public pc {

   friend class shadowpt;

   protected:
   
      // pc
      void transform(eye *parm);
      int  clip(eye *parm, int maxx, int maxy);

      // particle
      union {
         vector4f wwai;
         int iwai[4];
      };

      vector3f wcolor;

   public:
      // superclass
      int query_whatami() { return OBJECT_PARTICLE; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      
      // frameclass
      int dump_frame(FILE *outfile);
      
      // pc
      void bound_sphere();
      int  bound_box(eye *parm);
      void datacopy();

      int scan(camera *cparm, light *lmain, engine *proc);
      int beamscan(spotlight *spot, engine *proc);

      void render(camera *cparm, light *lmain, light *spot, engine *proc);
      void prender(engine *proc);
      void beamrender(spotlight *spot, engine *proc);
      
      // particle
      vector3f color;

      particle();
      virtual ~particle() {}
};

/* *************************************************************
************************************************************* */
class point_loader : public loader {

   public:
      superclass *make_object() { return new particle; }
      point_loader() {object_name = TOKEN_PARTICLE_STR; }
      virtual ~point_loader() {}
};


/* *************************************************************
   object to render poligonal data.
************************************************************* */
class shadowpt : public particle {

   public:
      // superclass
      int parse(FILE *infile, char *token) { return particle::parse(infile, token); }
      void preprocess(void *data) { particle::preprocess(data); }
      
      // shadowpt
      int  datacopy2(particle *pob, light *lmain);
      int  point2plane(float psplane[], light *lmain);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      virtual ~shadowpt() {}
};


#endif
