

#if !defined __OBJ_LOAD_H
#define __OBJ_LOAD_H


#include "polytype.h"
#include "shading.h"


/* *******************************************************************
******************************************************************* */
class obj_material_type : public dbl_llist {

   public:
   
      string_type name;
      vector3f ambient, diffuse, specular;
      float specn;
      texbase *tob;
      int material_id;
      int facecount;
      
      obj_material_type();
      virtual ~obj_material_type() {}
};


/* *******************************************************************
******************************************************************* */
class obj_loader : public file_loader {

   protected:
      polytype *ob;
      resource_type *current;

      dbl_llist_manager v_manager;
      dbl_llist_manager f_manager;
      dbl_llist_manager i_manager;
      dbl_llist_manager if_manager;
      dbl_llist_manager u_manager;

      int read_material(char *filename);
      
      int  extract_uv(char *filename, char *altname);
      void extract_shade(obj_material_type *mtr, shadetype *ilm);
      int  extract_material(char *filename, char *altname);
      int  extract_object(char *filename, char *altname);

   public:
      // basic_loader
      void cleanup();
      basic_loader *find_loader(sfile *data);

      // file_loader
      int read_data();
      void *extract(unsigned int type, char *altname, int level = 0);

      // obj_loader
      virtual ~obj_loader() {}
};

#endif

