

#if !defined __MENU_H
#define __MENU_H


#include <stdio.h>
#include "matrix.h"
#include "basic_dt.h"
#include "map.h"


#define WIDGETFLAG_NULL             0x0000
#define WIDGETFLAG_ACTIVE           0x0001   // disable select flag ( for modal )
#define WIDGETFLAG_HIGHLIGHT        0x0002   // highlight color ( highlight for focus )
#define WIDGETFLAG_SELECTED         0x0004   // selected color
#define WIDGETFLAG_SELECTABLE       0x0008   // selectable
#define WIDGETFLAG_INVISO           0x0010   // transparent
#define WIDGETFLAG_CENTER           0x0020   // center text
#define WIDGETFLAG_RIGHT_JUSTIFY    0x0040   // right justify text
//#define WIDGETFLAG_LEFT_JUSTIFY     0x0000  // left justify - default
#define WIDGETFLAG_BORDER           0x0080
#define WIDGETFLAG_SHOW             0x0100   // visible
#define WIDGETFLAG_CYCLE_FOREGROUND 0x0200
#define WIDGETFLAG_LOCK_OPTION      0x0400
#define WIDGETFLAG_NOBLINK_SELECT   0x0800

#define WIDGETMASK_COLOR            0x0006
#define WIDGETMASK_JUSTIFY          0x0060

#define WIDGET_GENERIC     0
#define WIDGET_FRAME       1
#define WIDGET_TEXT        2
#define WIDGET_BUTTON      3
#define WIDGET_TEXT_BUTTON 4
#define WIDGET_HSLIDER     5


#define MAX_WIN_WIDTH  640.0
#define MAX_WIN_HEIGHT 480.0


/* **********************************************************
********************************************************** */
class generic_widget : public dbl_llist {

   public:
      vector2i x, y;                // bounding box
      generic_widget *parent;       // parent widget
      int flags;
      dbl_llist_manager children;
      
      generic_widget() { parent = NULL; flags = WIDGETFLAG_SHOW; x[0] = x[1] = y[0] = y[1]=0; }
      virtual ~generic_widget() {}

      generic_widget *select(int pixel_x, int pixel_y);

      virtual int  query_whatami() { return WIDGET_GENERIC; }
      virtual int  query_whatwasi(int type) { return type == query_whatami(); }
      virtual int  parse(FILE *infile, char *token);
      virtual void preprocess(void *data);
      virtual void render(mapul *mapbuffer);
      virtual void refresh() {}
      virtual void perform(int task, void *data);
};

   
/* **********************************************************
********************************************************** */
class menu_data_type {

   public:
      int text_count;
      string_type *text_palette;
      generic_widget *highlight, *selected;
      generic_widget *main_widget;
            
      menu_data_type() { text_palette = NULL; main_widget = highlight = selected = NULL; }
      virtual ~menu_data_type() { if (text_palette) delete [] text_palette; }

      void read_menu_text(FILE *infile);
};


/* **********************************************************
********************************************************** */
class frame_widget : public generic_widget {

   public:
      int  query_whatami() { return WIDGET_FRAME; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void render(mapul *mapbuffer);

      vector4uc bordercolor, background;
      frame_widget() { flags |= WIDGETFLAG_INVISO; }
      virtual ~frame_widget() {}
};


/* **********************************************************
********************************************************** */
class text_widget : public generic_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_TEXT; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      void render(mapul *mapbuffer);
      
      string_type text;
      string_type text_font;
      int string_code;
      vector4uc foreground_color, background_color;
      
      text_widget() { string_code = 0; flags |= WIDGETFLAG_INVISO; }
      virtual ~text_widget() {}
};


/* **********************************************************
********************************************************** */
class button_widget : public generic_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_BUTTON; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      void render(mapul *mapbuffer);
      void refresh();

      vector4uc select_color, unselect_color, background_color, highlight_color;
      vector4uc current_color;
      float cycle_timer;
      int   action_code;
      
      button_widget() { cycle_timer = 0; flags |= WIDGETFLAG_INVISO | WIDGETFLAG_BORDER | WIDGETFLAG_SELECTABLE; }
      virtual ~button_widget() {}
};


/* **********************************************************
********************************************************** */
class text_button_widget : public button_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_TEXT_BUTTON; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      void render(mapul *mapbuffer);
      void refresh();

      int       string_code;
      vector4uc backup_color;
      
      text_button_widget() { string_code = 0; }
      virtual ~text_button_widget() {}
};


/* **********************************************************
********************************************************** */
class hslider_widget : public generic_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_HSLIDER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      void render(mapul *mapbuffer);
      void refresh();

      vector4uc foreground_color, background_color, highlight_color;
      vector4uc current_color;
      frame_widget *button;
      float value;
      int id;

      hslider_widget();
      virtual ~hslider_widget() {}

      virtual void set_value(float v);
};


#endif
