

#if !defined __MEMMAN_H
#define __MEMMAN_H

#include "matrix.h"
#include "map.h"
#include "basic_dt.h"

#define MM_EDGE                  0
#define MM_LIGHTBUFF             1
#define MM_POINTLIST             2
#define MAXLISTS                 3

#define MM_BUFFER                0
#define MM_SECONDARY_BUFFER      1
#define MM_ET                    1
#define MAXBUFFERS               2


typedef struct {

   union {
      vector3f point;
      fixed_pt fxpoint[3];
   };

   union {
      int id;               // use w/ wfbw, bw only
      vector3f uvz;
      fixed_pt fxuvz[3];
   };

   union {
      vector3f gnormal;
      vector3f color;
      fixed_pt fxcolor[3];
   };

} pointtype;


/* ************************************************************
************************************************************ */
class buffertype {

   public:
      char *buffer;
      int  size;

      buffertype() { buffer = NULL; size = 0; }
      virtual ~buffertype() { if (buffer) delete [] buffer; }
};


/* ************************************************************
************************************************************ */
class pointlisttype : public dbl_llist {

   public:
      pointtype pt;
      int index;

      virtual ~pointlisttype() {}
};


/* ************************************************************
************************************************************ */
class edgetype : public dbl_llist {

   public:
      pointtype start;

      float    dz;

      union {
         fixed_pt fxdx;
         float    dx;
      };

      union {
         vector4f dnormal;                  // phong/gouraud delta
         vector3f dcolor;
         fixed_pt fxdcolor[3];
      };

      union {
         vector3f duvz;                     // du,dv,diz
         fixed_pt fxduvz[3];
      };

      union {
         vector3f epoint;                   // use w/ wfbw, bw pm;u
         vector3f enormal;                  // use w/ pg
      };

      int starty, endy;
      
      virtual ~edgetype() {}
};


typedef edgetype *pedgetype;
typedef edgetype **ppedgetype;

/* ************************************************************
************************************************************ */
class lightbufftype : public dbl_llist {

   public:
      maplexel lbuff;
      
      virtual ~lightbufftype() {}
};


/* ************************************************************
************************************************************ */
class memman {

   protected:
      dbl_llist_manager *listmem;
      buffertype *buffermem;
      int listcount;
      int buffercount;
      
   public:
      memman(int maxlists, int maxbuffers);
      virtual ~memman();

      virtual void *pop(int item, int size = 0);
      void push(int item, dbl_llist *mem);     
};

#endif

