

#if !defined _MCTYPE_H

#include <stdio.h>

#define _MCTYPE_H


#define CINULL          0
#define CITEXTURE       1
#define CIRAYCAST       2
#define CI3DTEX         4
#define CITRANSPARENT   8
#define CIBITMAP        16
// #define CISPOT          32  (???)
#define CIINVISO        64
#define CIGHOST         128         // dont write into zbuffer
#define CIOVERWRITE     256        // dont do zbuffer checks

typedef enum colorenum {
   SHADOW       = -1,
   SHADE_NULL   =  0,
   DOT          =  1,
   WFBW         =  2,
   BW           =  3,
   CONSTANT     =  4,
   GOURAUD      =  5,
   FLAT         =  6,
   PHONG        =  7,
   PDOT         = 41,
   PWFBW        = 42,
   PBW          = 43,
   PCONSTANT    = 44,
   PFLAT        = 45,
   PGOURAUD     = 46,
   PPHONG       = 47,
   RSOLID       = 81,
   IRRADIANT    = 82
} colortype;


class shading_model {

    protected:
       colortype master_model;

    public:
        colortype model;

        shading_model() { master_model = WFBW; }
	virtual ~shading_model() {}
	
        void set_master(colortype x) { master_model = x; }
        colortype query_master() { return master_model; }

        void datacopy() { model = master_model; }

        void write_model(FILE *outfile, char *prestring, char *poststring);
        int  parse(char *token);
};


class shading_flag {

    protected:
       unsigned int master_info;

    public:
        unsigned int info;

        shading_flag() { master_info = 0; }
	virtual ~shading_flag() {}
	
        void datacopy() { info = master_info; }
        void mask_or(unsigned int x) { master_info |= x; }
        void mask_and(unsigned int x) { master_info &= x; }
        void mask_replace(unsigned int x) { master_info = x; }

        unsigned int query_master() { return master_info; }
};

extern char SHADE_DOT_STR[];
extern char SHADE_WFBW_STR[];
extern char SHADE_BW_STR[];
extern char SHADE_CONSTANT_STR[];
extern char SHADE_GOURAUD_STR[];
extern char SHADE_FLAT_STR[];
extern char SHADE_FALLAETX_STR[];
extern char SHADE_PHONG_STR[];
extern char SHADE_PDOT_STR[];
extern char SHADE_PWFBW_STR[];
extern char SHADE_PBW_STR[];
extern char SHADE_PCONSTANT_STR[];
extern char SHADE_PGOURAUD_STR[];
extern char SHADE_PFLAT_STR[];
extern char SHADE_PFALLAETX_STR[];
extern char SHADE_PPHONG_STR[];
extern char SHADE_RSOLID_STR[];
extern char SHADE_IRRADIANT_STR[];

#endif

