


#if !defined __MAP_H_
#define __MAP_H_


class map {

   public:
      unsigned int maxx, maxy;
      virtual void init_map(unsigned int x, unsigned int y) = 0;
      virtual void init_map(unsigned int x, unsigned int y, int offset_index) = 0;
      virtual void zero() = 0;

      virtual ~map() {}
};


class mapul : public map {

   public:
      unsigned int *alloc_data;
      unsigned int *data;
      unsigned int **pdata;

      void init_map(unsigned int x, unsigned int y);
      void init_map(unsigned int x, unsigned int y, int offset_index);
      void zero();
      void flip_bytes();

      int query_x() {
         return maxx;
      }

      int query_y() {
         return maxy;
      }

      mapul();
      virtual ~mapul();
};

class mapf : public map {

   public:
      float *alloc_data;
      float *data;
      float **pdata;

      void init_map(unsigned int x, unsigned int y);
      void init_map(unsigned int x, unsigned int y, int offset_index);
      void zero();

      mapf();
      virtual ~mapf();
};

class mapuc : public map {

   public:
      unsigned char *alloc_data;
      unsigned char *data;
      unsigned char **pdata;

      void init_map(unsigned int x, unsigned int y);
      void init_map(unsigned int x, unsigned int y, int offset_index);
      void zero();

      mapuc();
      virtual ~mapuc();
};


typedef struct {
   float zdata;
   unsigned int idbuff;
} lexel_type;

class maplexel : public map {

   public:
      lexel_type *alloc_data;
      lexel_type *data;
      lexel_type **pdata;

      void init_map(unsigned int x, unsigned int y);
      void init_map(unsigned int x, unsigned int y, int offset_index);
      void zero();

      maplexel();
      virtual ~maplexel();
};


typedef float * pfloat;
typedef float ** ppfloat;
typedef int * pint;
typedef unsigned int * puint;
typedef unsigned int ** ppuint;
typedef unsigned char * puchar;
typedef lexel_type *plexel_type;

#endif

