

#if !defined __LW_LOAD_H
#define __LW_LOAD_H


#include "polytype.h"
#include "shading.h"


/* *******************************************************************
******************************************************************* */
class material_type : public dbl_llist {

   public:
      string_type name;
      float shade[3];
      float diffuse, specular, lum, specn;
      int flag_dbl_side;
      int facecount;
      int material_id;
      
      material_type() {
         shade[0] = shade[1] = shade[2] = 0;
         diffuse = specular = lum = 0;
         specn = 1.0f;
         flag_dbl_side = 0;
         facecount = 0;
         material_id = 0;
      }

      virtual ~material_type() {}
};


/* *******************************************************************
******************************************************************* */
class lightwave_loader : public file_loader {

   protected:
      polytype *ob;
      resource_type *current;
      vector3f *vertex;
      int countvertex;
      dbl_llist_manager i_manager;
      dbl_llist_manager f_manager;
      
      int scan_pnts(int *bytesize);
      int scan_srfs(int *bytesize);
      int scan_pols(int *bytesize);
      int scan_surf(int *bytesize);
      
      void extract_shade(material_type *itr, shadetype *ilm);
      int  extract_material();
      int  extract_object();

      void internal_cleanup();
      
   public:
      // basic_loader
      void cleanup();
      basic_loader *find_loader(sfile *data);

      // file_loader 
      int read_data();
      void *extract(unsigned int type, char *altname, int level = 0);

      // lightwave_loader
      lightwave_loader() { vertex = NULL; }
      virtual ~lightwave_loader() { if (vertex) delete [] vertex; }
};

#endif

