#if !defined __LINE_H
#define __LINE_H

#include "base.h"

class shadline;

/* *************************************************************
************************************************************* */
class line : public pc {

   friend class shadline;

   protected:

      // pc
      void transform(eye *parm);
      int clip(eye *parm, int maxx, int maxy);
      
      // line
      vector4f wwai[2];
      vector3f wcolor[2];

   public:
   
      // superclass
      int query_whatami() { return OBJECT_LINE; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      
      // frameclass
      int  dump_frame(FILE *outfile);
      
      // pc
      int  bound_box(eye *parm);
      void bound_sphere();
      void datacopy();

      int beamscan(spotlight *spot, engine *proc);
      int scan(camera *cparm, light *lmain, engine *proc);

      void beamrender(spotlight *spot, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);
      void prender(engine *proc);
      
      // line
      vector3f wwi;
      vector3f color[2];

      line() {
         copyarray3(wwi, center);
         color[0][0] = color[0][1] = color[0][2] =
         color[1][0] = color[1][1] = color[1][2] = 1.0;
      }

      virtual ~line() {}
};


/* *************************************************************
************************************************************* */
class line_loader : public loader {

   public:
      superclass *make_object() { return new line; }
      line_loader() { object_name = TOKEN_LINE_STR; }

      virtual ~line_loader() {}
};


/* *************************************************************
************************************************************* */
class shadline : public line {

   public:
					// superclass
      int parse(FILE *infile, char *token) { return line::parse(infile, token); }
      void preprocess(void *data) { line::preprocess(data); }
					// pc
      void render(camera *cparm, light *lmain, light *spot, engine *proc);
					// shadline
      int  datacopy2(line *pob, light *lmain);
      int  point2plane(float *psplane, light *lmain);

      virtual ~shadline() {}
};


#endif

