

#if !defined __LIGHT_H
#define __LIGHT_H

#include "eye.h"
#include "shading.h"
#include "datatype.h"
#include "memman.h"


#define MAXLDIM 200

#define simple_light    \
                        \
   float NL;            \
                        \
   NL = dotproduct3(gnormal, vlight);   \
                        \
   if (NL <= 0)         \
      return;           \
                        \
   rcolor[0] += mIp[0]*shade->kp[0]*NL; \
   rcolor[1] += mIp[1]*shade->kp[1]*NL; \
   rcolor[2] += mIp[2]*shade->kp[2]*NL;


typedef enum lightclassenum {
   GLOBAL_LIGHT = 0, SPOT_LIGHT = 1
} lightclass;


/* *************************************************************
************************************************************* */
class light : public eye {

   protected:

      // light
      virtual void lighting(float *surface, float *gnormal, float *rcolor,
                          shadetype *shade, float *mIp, float *vlight, float dist2surface);

   public:

      // superclass
      int query_category() { return CLASS_LIGHT; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data) { eye::preprocess(data); }

      // light
      vector3f Ia, Ip, fatt;
      int      fattflag;

      vector4f transloc, transvec;

      light() {
         vpn[0] = vpn[1] = 0; vpn[2] = 1;
         Ia[0] = Ia[1] = Ia[2] = 0.3f;
         Ip[0] = Ip[1] = Ip[2] = 0.7f;
         fatt[0] = fatt[1] = fatt[2] = 0.0;
         fattflag = 0;
      }

      virtual ~light() {}
      
      void set_ambient(int *ka, float *ambient, int *lum);

      virtual lightclass query_class() { return GLOBAL_LIGHT; }

      virtual void intensity(float *surface, float *gnormal, float *rcolor,
                     eye *parm, shadetype *shade, int source_id) = 0;
      virtual void xform(eye *parm) = 0;
};

typedef light * plight;


/* *************************************************************
************************************************************* */
class far_light : public light {

   public:

      // superclass
      int  query_whatami() { return OBJECT_FAR; }
      int  query_whatwasi(int type);
      void preprocess(void *data);
      int  parse(FILE *infile, char *token);

      // frameclass
      int  dump_frame(FILE *outfile);

      // eye
      float zscale(float n, float d) { return n; }
      void screen2map(float *v);
      void map2screen(float *v);

      // light
      void intensity(float *surface, float *gnormal, float *rcolor,
                      eye *parm, shadetype *shade, int source_id);
      void xform(eye *parm);
      
      virtual ~far_light() {}
};


/* *************************************************************
************************************************************* */
class light_loader : public loader {

   public:
      superclass *make_object() { return new far_light; }
      superclass *parse(FILE *infile, char *token);

      light_loader() { object_name = TOKEN_LIGHT_STR; }
      virtual ~light_loader() {}
};


/* *************************************************************
************************************************************* */
class far_light_loader : public loader {

   public:
      superclass *make_object() { return new far_light; }
      far_light_loader() { object_name = TOKEN_FAR_STR; }
      virtual ~far_light_loader() {}
};


/* *************************************************************
************************************************************* */
class point_light : public light {

   public:
      // superclass
      int  query_whatami() { return OBJECT_POINT; }
      int  query_whatwasi(int type);
      void preprocess(void *data) { light::preprocess(data); }
      int  parse(FILE *infile, char *token) { return light::parse(infile, token); }

      // frameclass
      int  dump_frame(FILE *outfile);

      // eye
      float zscale(float n, float d) { return -n/d; }
      void screen2map(float *v);
      void map2screen(float *v);

      // light
      void intensity(float *surface, float *gnormal, float *rcolor,
                      eye *parm, shadetype *shade, int source_id);
      void xform(eye *parm);
      
      virtual ~point_light() {}
};


/* *************************************************************
************************************************************* */
class point_light_loader : public loader {

   public:
      superclass *make_object() { return new point_light; }
      point_light_loader() { object_name = TOKEN_POINT_STR; }
      virtual ~point_light_loader() {}
};


/* *************************************************************
************************************************************* */
class simple_far_light : public far_light {

   protected:

      // light
      void lighting(float *surface, float *gnormal, float *rcolor,
                    shadetype *shade, float *mIp, float *vlight, float dist2surface);

   public:

      // frameclass
      int dump_frame(FILE *outfile);
      
      virtual ~simple_far_light() {}
};


/* *************************************************************
************************************************************* */
class simple_far_light_loader : public loader {

   public:
      superclass *make_object() { return new simple_far_light; }
      simple_far_light_loader() { object_name = TOKEN_SIMPLE_FAR_STR; }

      virtual ~simple_far_light_loader() {}
};


/* *************************************************************
************************************************************* */
class simple_point_light : public point_light {

   protected:

      // light
      void lighting(float *surface, float *gnormal, float *rcolor,
        shadetype *shade, float *mIp, float *vlight, float dist2surface);

   public:

      // frameclass
      int dump_frame(FILE *outfile);
      
      virtual ~simple_point_light() {}
};


/* *************************************************************
************************************************************* */
class simple_point_light_loader : public loader {

   public:
      superclass *make_object() { return new simple_point_light; }
      simple_point_light_loader() { object_name = TOKEN_SIMPLE_POINT_STR; }

      virtual ~simple_point_light_loader() {}
};


/* *************************************************************
************************************************************* */
class spotlight : public light {

   public:

      // superclass
      void preprocess(void *data);
      int parse(FILE *infile, char *token);
      
      // light
      lightclass query_class() { return SPOT_LIGHT; }
      void xform(eye *parm);
      
      // spotlight
      texbase *tob;
      float area;

      float length, width, distance2plane;
      string_type texname;

      int maxx, maxy;
      float ztscale;

      lightbufftype *lbuff;

      spotlight() {
         tob = NULL;
         area = 1;
         length = width = distance2plane = 1.0;
         lbuff = NULL;
      }

      virtual ~spotlight() { if (lbuff) delete lbuff; }
      
      int init_buff(memman *control);
};


/* *************************************************************
************************************************************* */
class beam_far : public spotlight {

   public:
      // superclass
      int query_whatami() { return OBJECT_FAR; }
      int query_whatwasi(int type);

      // frameclass
      int dump_frame(FILE *outfile);
      
      // eye
      float zscale(float n, float d) { return n; }
      void screen2map(float *v);
      void map2screen(float *v);
      
      // light
      void intensity(float *surface, float *gnormal, float *rcolor,
                      eye *parm, shadetype *shade, int source_id);

      virtual ~beam_far() {}
};


/* *************************************************************
************************************************************* */
class beam_far_loader : public loader {

   public:
      superclass *make_object() { return new beam_far; }
      beam_far_loader() { object_name = TOKEN_BEAM_FAR_STR; }

      virtual ~beam_far_loader() {}
};


/* *************************************************************
************************************************************* */
class beam_point : public spotlight {

   public:
   
      // superclass
      int query_whatami() { return OBJECT_POINT; }
      int query_whatwasi(int type);

      // frameclass
      int dump_frame(FILE *outfile);
      
      // eye
      float zscale(float n, float d) { return -n/d; }
      void screen2map(float *v);
      void map2screen(float *v);
      
      // light
      void intensity(float *surface, float *gnormal, float *rcolor,
                      eye *parm, shadetype *shade, int source_id);

      virtual ~beam_point() {}
};


/* *************************************************************
************************************************************* */
class beam_point_loader : public loader {

   public:
      superclass *make_object() { return new beam_point; }
      beam_point_loader() { object_name = TOKEN_BEAM_POINT_STR; }
      virtual ~beam_point_loader() {}
};


/* *************************************************************
************************************************************* */
class simple_beam_far : public beam_far {

   protected:
   
      // light
      void lighting(float *surface, float *gnormal, float *rcolor,
                    shadetype *shade, float *mIp, float *vlight, float dist2surface);

   public:

      // frameclass
      int dump_frame(FILE *outfile);

      virtual ~simple_beam_far() {}
};


/* *************************************************************
************************************************************* */
class simple_beam_far_loader : public loader {

   public:
      superclass *make_object() { return new simple_beam_far; }
      simple_beam_far_loader() { object_name = TOKEN_SIMPLE_BEAM_FAR_STR; }
      virtual ~simple_beam_far_loader() {}
};


/* *************************************************************
************************************************************* */
class simple_beam_point : public beam_point {

   protected:
   
      // light
      void lighting(float *surface, float *gnormal, float *rcolor,
                    shadetype *shade, float *mIp, float *vlight, float dist2surface);

   public:
   
      // frameclass
      int dump_frame(FILE *outfile);

      virtual ~simple_beam_point() {}
};


/* *************************************************************
************************************************************* */
class simple_beam_point_loader : public loader {

   public:
      superclass *make_object() { return new simple_beam_point; }
      simple_beam_point_loader() { object_name = TOKEN_SIMPLE_BEAM_POINT_STR; }
      virtual ~simple_beam_point_loader() {}
};

#endif
