

#if !defined __IMGMAN_H
#define __IMGMAN_H

#include "map.h"
#include "basic_dt.h"


#define IMGMAN_TEXTURE_CLAMPED 0x00
#define IMGMAN_TEXTURE_REPEAT  0x01


/* *******************************************************
******************************************************* */
class imgman_i2c_type : public dbl_llist {

   public:
      mapul *itob;
      mapuc *ctob;

      imgman_i2c_type() { itob = NULL; ctob = NULL; }
      virtual ~imgman_i2c_type() {}
};


void imgman_internal2external(unsigned char *internal, unsigned char *external, int type);
void imgman_external2internal(unsigned char *external, unsigned char *internal, int type);

void imgman_convert_2428(mapul *source, unsigned int *out_palette, mapuc *out, int type);
void imgman_convert_multiple_2428(dbl_llist_manager *inout, unsigned int *out_palette, int type);
void imgman_swap_palettes(mapul *source, mapul *palette, mapul *out, int type);
void imgman_greyscale(mapul *source, mapul *out, int type);

void imgman_resize_length(mapul *source, mapul *out, int new_length);
void imgman_resize_height(mapul *source, mapul *out, int new_height);
void imgman_resize(mapul *source, mapul *out, int new_length, int new_height);

void imgman_resize_length(mapuc *source, mapuc *out, int new_length);
void imgman_resize_height(mapuc *source, mapuc *out, int new_height);
void imgman_resize(mapuc *source, mapuc *out, int new_length, int new_height);

void imgman_build_mipmap(mapul *source, mapul *out, int repeat, int type);

#endif

