

#if !defined __HPX_LOAD_H
#define __HPX_LOAD_H


#include "polytype.h"
#include "shading.h"


#define HPX_VERSION_STR "HPXV001"


/* *******************************************************************
******************************************************************* */
typedef struct {

   vector2f uv;
   vector4f pt;
   vector4uc color;
} hpx_vertex;


/* *******************************************************************
******************************************************************* */
class index_type : public dbl_llist {

   public:
      int id;

      virtual ~index_type() {}
};


/* *******************************************************************
******************************************************************* */
class choice_type : public index_type {

   public:
      dbl_llist_manager parent_manager;
      dbl_llist_manager switch_manager;
      dbl_llist_manager obj_manager;

      virtual ~choice_type() {}
};


/* *******************************************************************
******************************************************************* */
class hpx_material : public dbl_llist {

   public:
      vector3f ka, kd, ks, ke;
      float specn; // 10 - 120
      float alpha;
      unsigned int color;
      int source;

      virtual ~hpx_material() {}
};


/* *******************************************************************
******************************************************************* */
class hpx_geometry : public index_type {

   public:
      vector3f center;
      int vertex_count;
      hpx_vertex *vertex_palette;
      dbl_llist_manager geometry_manager;

      hpx_geometry() { vertex_palette = NULL; }
      virtual ~hpx_geometry() { if (vertex_palette) delete [] vertex_palette; }
};


/* *******************************************************************
******************************************************************* */
class hpx_loader : public file_loader {

   protected:

      // hpx_loader

      dbl_llist_manager texture_palette;
      dbl_llist_manager base_material_palette;
      dbl_llist_manager material_palette;

      choice_type manager;

      hpx_geometry geo_manager;

      virtual int read_textures(char *token, int texture_count, int *overread);
      int read_materials(char *token, int material_count, int *overread);

      virtual int read_geometry(dbl_llist_manager *manager, char *token, float x, float y, float z);
      int read_animation(dbl_llist_manager *manager, char *token, float x, float y, float z);
      int read_subface(dbl_llist_manager *manager, char *token, int argi, float x, float y, float z);
      int read_choice(choice_type *parent_ob, char *token, int argi, float x, float y, float z);

      int count_single_switch_vertex(choice_type *choice, int *id);
      int count_triangle_vertex(dbl_llist_manager *manager);
      int count_parent_vertex(dbl_llist_manager *manager);
      int count_switch_vertex(dbl_llist_manager *manager);
      int count_vertex(choice_type *manager);

      int extract_triangle(hpx_geometry *geo_manager, hpx_geometry *gtr);
      int extract_parent(hpx_geometry *geo_manager, choice_type *ptr);
      int extract_switch(hpx_geometry *geo_manager, choice_type *ptr);
      int extract_geo(hpx_geometry *geo_manager, choice_type *manager);

      void extract_material(hpx_material *src, shadetype *ilm);

      int export_spg(polytype *ob);
      int export_ilm(shadelist *ilm);
      int export_tex(texpolygon *texpoly);

   public:
      // basic_loader
      void cleanup();
      basic_loader *find_loader(sfile *data);
      
      // file_loader
      int query_levels();
      int read_data();
      void *extract(unsigned int type, char *altname, int level = 0);

      // hpx_loader
      virtual ~hpx_loader() {}
};


/* *******************************************************************
******************************************************************* */
class hps_loader : public hpx_loader {

   protected:
      // hpx_loader
      int read_textures(char *token, int texture_count, int *overread);
      int read_geometry(dbl_llist_manager *manager, char *token, float x, float y, float z);

   public:
      // basic_loader
      basic_loader *find_loader(sfile *data);

      // file_loader
      int read_data();

      // hps_loader
      virtual ~hps_loader() {}
};

#endif

