

#if !defined __GLTEXTURE_H
#define __GLTEXURE_H


#include "texture.h"

#define TEXTURE_BLOCK_TYPE_OGL 0x1001


/* ********************************************************************
******************************************************************** */
class texture_block_ogl : public basic_texture_block {

   public:
      // basic_texture_block
      int query_whatami() { return TEXTURE_BLOCK_TYPE_OGL; }

      // texture_block_ogl
      int tex_id;

      texture_block_ogl() { tex_id = -1; }
      virtual ~texture_block_ogl() {}
};


/* ********************************************************************
******************************************************************** */
class gl_texture : public texture {

   protected:
      image_coder *current_loader;

      void cleanup();

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      void replace_data(void *subresource);

      // texbase
      int pre_process_texture();
      void build_mipmaps(dbl_llist_manager *image_handler, int flip);
      int read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);
      unsigned int query_texel(float x, float y, float *color, int frame, float d);

      // gl_texture
      gl_texture() { current_loader = NULL; }
      virtual ~gl_texture() {}
};


/* ********************************************************************
******************************************************************** */
class gl_texture256 : public texture256 {

   protected:
      image_coder *current_loader;

      void cleanup();

   public:
      // resource_type
      void update(float current_time);
      void *query_data();
      void replace_data(void *subresource);

      // texbase
      int pre_process_texture();
      void build_mipmaps(dbl_llist_manager *image_handler, int flip);
      int read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip);
      unsigned int query_texel(float x, float y, float *color, int frame, float d);

      // gl_texture256
      gl_texture256() { current_loader = NULL; }
      virtual ~gl_texture256() {}
};

#endif

