

/* *************************************************************
   This file contains all the global data types for my programs
************************************************************* */

#if !defined (__GLOBAL_H)
#define __GLOBAL_H

#include <stdio.h>

#include "basic_dt.h"

#define RENDERER_PIXCON	0
#define RENDERER_OPENGL	1

#define BACKGROUND  0
#define MIDGROUND   1
#define FOREGROUND  2
#define MAXGROUND   3

#define FILENAME_DEFAULT_COMMANDS "config/default.cmd"
#define FILENAME_CURRENT_COMMANDS "config/current.cmd"

extern float SHADOW_PLANE[4];

extern int PENCILTEST;
extern int NOSHADOW;
extern int NOSCREEN;
extern int SILENT;

extern int GAMMA;
extern unsigned char GAMMALUT[1024];
extern unsigned char *PGAMMA;

extern int ANTIALIAS;
extern int DEFLST;

extern int DYNAMIC_LOADER;
extern int STANDARD_TEXTURE_PROCESSING;

extern string_type SANTIALIAS;
extern string_type SDEFLST;

extern int RENDER_MODE;

extern string_type MATERIAL_PATH;
extern string_type OBJECT_PATH;
extern string_type TEXTURE_PATH;
extern string_type ATOM_PATH;
extern string_type EVENT_PATH;
extern string_type FONT_PATH;
extern string_type FILTER_PATH;

extern unsigned int  PLATFORM_SLASH;

extern int object_counter;
extern int global_statistic_object_count;
extern int global_statistic_texture_count;
extern int global_statistic_sphere_count;
extern int global_statistic_material_count;
extern int global_statistic_uv_count;

extern float front;
extern float back;

extern int global_sfx_volume;
extern int global_music_volume;
extern int global_voice_volume;

extern FILE *logfile;

extern char perror_buffer[];
void pprintf(char *buffer);

#endif

