

#if !defined __GFX_H
#define __GFX_H

#include "WIN_VIRTUAL.h"
#include "font.h"
#include "base.h"

#define GFX_NULL                0x0000
#define GFX_TRANSPARENT         0x0001
#define GFX_INVISO              0x0002
#define GFX_OVERWRITE           0x0004
#define GFX_GHOST               0x0008
#define GFX_FOG                 0x0010
#define GFX_DEPTH_TEST          0x0020
#define GFX_CLEAR_COLOR_BUFFER  0x0040
#define GFX_TEXTURE             0x0080
#define GFX_NORMALIZE           0x0100
#define GFX_LIGHTING            0x0200
#define GFX_CULL_FACE           0x0400
#define GFX_CLEAR_DEPTH_BUFFER  0x0800

#define GFX_PLACEMENT_CENTER      0
#define GFX_PLACEMENT_LOWER_LEFT  1
#define GFX_PLACEMENT_UPPER_LEFT  2
#define GFX_PLACEMENT_UPPER_RIGHT 3
#define GFX_PLACEMENT_LOWER_RIGHT 4

#define GFX_NODRAW      0
#define GFX_LINES       1
#define GFX_LINE_LOOP	2
#define GFX_POINTS      3 
#define GFX_LINE_STRIP	4


/* *************************************************************
************************************************************* */
class base_gfx {

   public:
      unsigned int gfx_state;
      int gfx_current_texid;

      base_gfx();
      virtual ~base_gfx();

      virtual void gfxInit();
      virtual void gfxDest();

      virtual void gfxSetTexture(basic_texture_block *tex);
      virtual font_type *gfxReadFont(char *filename, int type) = 0;

      virtual font_type *gfxAllocFontObject(int type) = 0;
      virtual pc *gfxAllocRenderObject(int type) = 0;

      virtual void gfxPointSize(float x) = 0;
      virtual void gfxRectiv(mapul *canvas, int *ll, int *ur) = 0;
      virtual void gfxClear(mapul *mapbuffer, mapf *zdata) = 0;

      virtual void gfxBegin(unsigned int md, mapul *cvs) = 0;
      virtual void gfxEnd() = 0;
      virtual void gfxColor3ubv(unsigned char *color) = 0;
      virtual void gfxVertex2iv(int *v) = 0;

      virtual void gfxEnable(unsigned int cap) = 0;
      virtual void gfxDisable(unsigned int cap) = 0;

      virtual void gfxSetColor(unsigned char *src, unsigned char *rgb) = 0;
      virtual void gfxSnapshot(char *filename, mapul *mapbuffer, image_coder *coder) = 0;
      virtual void gfxBitblt(BLTwindow *win, mapul *mapbuffer) = 0;

      virtual void gfx2DMode(int winx, int winy) = 0;
      virtual void gfx3DModeBegin(camera *cparm, light *lmain, int winx, int winy) = 0;
      virtual void gfx3DModeEnd() = 0;

      virtual void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int *ll, int *ur, float *lluv, float *uruv, int transflag) = 0;
      virtual void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int left, int bottom, int right, int top, int transflag) = 0;
      virtual void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int x, int y, int placeflag, int transflag) = 0;

      virtual void gfxFlatIncrementTime(pc *ob, float inc) = 0;
      virtual void gfxPolygonIncrementTime(pc *ob, float inc) = 0;
      virtual void gfxFxflatInit(pc *ob, texbase *tob) = 0;
      virtual void gfxPolygonInit(pc *ob) = 0;
};


/* *************************************************************
************************************************************* */
class sw_gfx : public base_gfx {

   protected:
     int begin_flag;
     vector2i first_pt;
     vector2i last_pt;
     int pointsize;
     int pointoffset;
     unsigned int mode;
     mapul *canvas;
     unsigned int tc_color;

     void init_state();

   public:
      // base_gfx
      void gfxInit();
      void gfxDest();

      font_type *gfxReadFont(char *filename, int type);

      font_type *gfxAllocFontObject(int type);
      pc *gfxAllocRenderObject(int type);

      void gfxPointSize(float x);
      void gfxRectiv(mapul *canvas, int *ll, int *ur);
      void gfxClear(mapul *mapbuffer, mapf *zdata);

      void gfxBegin(unsigned int md, mapul *cvs);
      void gfxEnd();
      void gfxColor3ubv(unsigned char *color);
      void gfxVertex2iv(int *v);

      void gfxEnable(unsigned int cap);
      void gfxDisable(unsigned int cap);

      void gfxSetColor(unsigned char *src, unsigned char *rgb);
      void gfxSnapshot(char *filename, mapul *mapbuffer, image_coder *coder);
      void gfxBitblt(BLTwindow *win, mapul *mapbuffer);

      void gfx2DMode(int winx, int winy);
      void gfx3DModeBegin(camera *cparm, light *lmain, int winx, int winy);
      void gfx3DModeEnd();

      void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int *ll, int *ur, float *lluv, float *uruv, int transflag);
      void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int left, int bottom, int right, int top, int transflag);
      void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int x, int y, int placeflag, int transflag);

      void gfxFlatIncrementTime(pc *ob, float inc);
      void gfxPolygonIncrementTime(pc *ob, float inc);
      void gfxFxflatInit(pc *ob, texbase *tob);
      void gfxPolygonInit(pc *ob);

      // sw_gfx
      sw_gfx() { init_state(); }
      virtual ~sw_gfx() {}
};


/* *************************************************************
************************************************************* */
class ogl_gfx : public base_gfx {

   protected:
      int begin_flag;
      int blendflag;
      int old_ghost_state;
      int old_transdepth_state;
      int buffer_state;
      dbl_llist_manager texid_manager;

   public:
      // base_gfx
      void gfxInit();

      void gfxSetTexture(basic_texture_block *tex);
      font_type *gfxReadFont(char *filename, int type);

      font_type *gfxAllocFontObject(int type);
      pc *gfxAllocRenderObject(int type);

      void gfxPointSize(float x);
      void gfxRectiv(mapul *canvas, int *ll, int *ur);
      void gfxClear(mapul *mapbuffer, mapf *zdata);

      void gfxBegin(unsigned int md, mapul *cvs);
      void gfxEnd();
      void gfxColor3ubv(unsigned char *color);
      void gfxVertex2iv(int *v);

      void gfxEnable(unsigned int cap);
      void gfxDisable(unsigned int cap);

      void gfxSetColor(unsigned char *src, unsigned char *rgb);
      void gfxSnapshot(char *filename, mapul *mapbuffer, image_coder *coder);
      void gfxBitblt(BLTwindow *win, mapul *mapbuffer);

      void gfx2DMode(int winx, int winy);
      void gfx3DModeBegin(camera *cparm, light *lmain, int winx, int winy);
      void gfx3DModeEnd();

      void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int *ll, int *ur, float *lluv, float *uruv, int transflag);
      void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int left, int bottom, int right, int top, int transflag);
      void gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int x, int y, int placeflag, int transflag);

      void gfxFlatIncrementTime(pc *ob, float inc);
      void gfxPolygonIncrementTime(pc *ob, float inc);
      void gfxFxflatInit(pc *ob, texbase *tob);
      void gfxPolygonInit(pc *ob);

      // ogl_gfx
      ogl_gfx();
      virtual ~ogl_gfx();

      unsigned int ogl_gfxAllocTexID(string_type *filename, int *found);
      void ogl_gfxDeallocTexID(unsigned int id, string_type *filename);
};

void gfx_get_screen_dim(int *winx, int *winy);

#endif

