

#if !defined __GAMEQURK_H
#define __GAMEQURK_H

#include "quark.h"
#include "sphrtype.h"
#include "gstring.h"

#define CLASS_GAME               10

#define OBJECT_GAMEATOM         100
#define OBJECT_FXMANAGER        101
#define OBJECT_FOLLOW           102
#define OBJECT_CAMERA_CONTROL   103

#define OBJECT_GAMEQUARK        120
#define OBJECT_ANTINEUTRON      121
#define OBJECT_ANTIFLAT         122
#define OBJECT_SUBFOLLOW        123

#define OBJECT_FLAT             200
#define OBJECT_PARTICLE_CLOUD   201
#define OBJECT_FXPOLYGON        202
#define OBJECT_FXFLAT           203
#define OBJECT_GLFLAT           205

#define OBJECT_FX_TYPE          210

#define GAMEFLAG_GREEN          0x00010000        // neutral
#define GAMEFLAG_BLUE           0x00020000        // player's side
#define GAMEFLAG_RED            0x00040000        // player's enemies
#define GAMEFLAG_ALLIANCE_MASK  0x00070000

#define GAMEFLAG_TARGETABLE     0x00080000        // flag if targetable by guns(qrk)/equipment(atm)
#define GAMEFLAG_DEATHCHECK     0x00100000        // flag if gamequark can "die"
#define GAMEFLAG_COMPARTMENTALIZED 0x00200000
#define GAMEFLAG_PHYSICAL       0x00400000

#define DATAFLAG_DEFAULT_CAMERA_STATE 0x00000001
#define DATAFLAG_FOLLOW_DISTANCE      0x00000002
#define DATAFLAG_PERCEIVED_VELOCITY   0x00000003
#define DATAFLAG_AI_NEW_TASK          0x00000004
#define DATAFLAG_AI_REMOVE_TASK       0x00000005

#ifdef set_nzbuff
#undef set_nzbuff
#endif

#define setcolor(dst, src) \
   dst[REDINDEX]   = BYTE_LUT(FIXED_TO_INT(src[0])); \
   dst[GREENINDEX] = BYTE_LUT(FIXED_TO_INT(src[1])); \
   dst[BLUEINDEX]  = BYTE_LUT(FIXED_TO_INT(src[2]))

#define setsimplecolor(dst, d0, d1, d2) \
   dst[REDINDEX]   = BYTE_LUT(d0.iflt2int[0]); \
   dst[GREENINDEX] = BYTE_LUT(d1.iflt2int[0]); \
   dst[BLUEINDEX]  = BYTE_LUT(d2.iflt2int[0])

#define settexcolor(dst, offset, src) \
   dst[REDINDEX]   = *(offset + src[3]);  \
   dst[GREENINDEX] = *(offset + src[2]);  \
   dst[BLUEINDEX]  = *(offset + src[1])


#define set_zbuff(zdata, data, mz, dcolor)       \
   zdata = mz;   \
   data = *(unsigned int *)dcolor

#define set_nzbuff(data, dcolor)       \
   data = *(unsigned int *)dcolor

#define set_trans(data, dcolor)       \
   if ((dcolor)[0] > ((unsigned char *)&data)[0])   \
      ((unsigned char *)&data)[0] = (dcolor)[0];    \
   if ((dcolor)[1] > ((unsigned char *)&data)[1])   \
      ((unsigned char *)&data)[1] = (dcolor)[1];    \
   if ((dcolor)[2] > ((unsigned char *)&data)[2])   \
      ((unsigned char *)&data)[2] = (dcolor)[2]


#define GATOM_STATUS(xxx) ((xxx) && \
                           ((gameatom *)(xxx)->htree)->total_hp && \
                           (((gameatom *)(xxx)->htree)->flags & (GAMEFLAG_TARGETABLE | QUARK_FLAG_ACTIVE)) == (GAMEFLAG_TARGETABLE | QUARK_FLAG_ACTIVE))

#define GQUARK_STATUS(xxx, yyy) ((xxx) && \
                                 ((xxx)->flags & (GAMEFLAG_TARGETABLE | QUARK_FLAG_ACTIVE)) == (GAMEFLAG_TARGETABLE | QUARK_FLAG_ACTIVE) && \
                                 (((yyy)->flags & QUARK_FLAG_ACTIVE) && \
                                  ((((yyy)->flags & GAMEFLAG_COMPARTMENTALIZED) && (yyy)->total_hp) || \
                                   ((gamequark *)(xxx))->total_hp)) && \
                                 (xxx)->query_category() == CLASS_GAME)


/* ****************************************************************
**************************************************************** */
class gamequark : public quark {

   protected:
      // quark
      void calc_initmx(vector4f *in, vector4f *out);

      // gamequark
      virtual void sum_hp(quark *target, quark *parent);
      virtual void deathcheck(quark *parent);

   public:
      // superclass
      int  query_category() { return CLASS_GAME; }
      int  query_whatami() { return OBJECT_GAMEQUARK; }
      int  query_whatwasi(int type);
      void preprocess(void *data);
      int  parse(FILE *infile, char *token);

      // quark
      void setup();
      void render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      int  query_specific_data(unsigned int type, void *data);

      // gamequark
      int init_hp, hp, total_hp;
      atom_list_type *atomparent;
      vector4f perceived_vel; // first 3 elements is the vector*speed, 4th element is the timescale

      gamequark() { init_hp = 0; atomparent = NULL; }
      virtual ~gamequark() {}

      virtual int apply_damage(unsigned int properties, int *damage, float *pos, vector4f *mx);
};


/* ****************************************************************
    // replacement for "quark" objects
**************************************************************** */
class gamequark_loader : public quark_loader {

   protected:
      superclass *make_object() { return new gamequark; }

   public:

      gamequark_loader() {
         object_name = TOKEN_GAMEQUARK_STR;
         alias_name  = TOKEN_QUARK_STR;
      }

      virtual ~gamequark_loader() {}
};


/* ****************************************************************
**************************************************************** */
class gameatom : public atom {

   protected:
      // quark
      void calc_initmx(vector4f *in, vector4f *out);

      // gameatom
      virtual void sum_hp(quark *target, quark *parent);

   public:
      // superclass
      int  query_whatami() { return OBJECT_GAMEATOM; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);

      // quark
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      int  query_specific_data(unsigned int type, void *data);
      void new_action(FILE *infile, float  timefactor, char *buffer) { atom::new_action(infile, timefactor, buffer); }

      // atom
      basic_event *read_event(FILE *infile, char *token, int frame_offset);
      void new_action(int frameno, dbl_llist_manager *hiearchy_manager);

      // gameatom
      string_type  filename;
      int          total_hp;
      vector4f     perceived_vel;
      string_type  full_name;

      virtual ~gameatom() {}

      virtual int apply_damage(gamequark *child, unsigned int properties, int *damage, float *pos, vector4f *mx);
};


/* ****************************************************************
    // replacement for "quark" objects
**************************************************************** */
class gameatom_loader : public quark_loader {

   protected:
      superclass *make_object() { return new gameatom; }

   public:

      gameatom_loader() {
         object_name = TOKEN_GAMEATOM_STR;
         alias_name  = TOKEN_ATOM_STR;
      }

      virtual ~gameatom_loader() {}
};


/* ****************************************************************
**************************************************************** */
class target_type {

   public:
      atom_list_type *object;
      quark *specific_parent;
      quark *specific;

      target_type() { object = NULL; specific_parent = NULL; specific = NULL; }
};


#endif

