

#if !defined __GAMEGINE_H
#define __GAMEGINE_H


#include "soundman.h"
#include "fxman.h"
#include "user_io.h"
#include "equipmnt.h"
#include "global.h"
#include "gfx.h"


#define RESOURCE_SPHERE       0x20000010
#define RESOURCE_ATOM_LOADER  0x20000011
#define RESOURCE_EQUIP_LOADER 0x20000012

#define FILETYPE_SPHERE 0x00010000


/* *************************************************************
************************************************************* */
class game_manager : public frame_manager {

   protected:

      // game_manager
      dbl_llist_manager sphere_list;
      dbl_llist_manager atom_loader_list;
      dbl_llist_manager equip_loader_list;

   public:

      // resource_manager
      void reset();

      void register_resource_object(int type, void *data);
      void *find_resource_object(int type, char *id, char *alias);
      void *get_resource_object(int type);
      void update(float current_time);

      // frame_manager
      texbase *alloc_texture(sfile *sinfile, dbl_llist_manager *handler, image_coder **loader, int flag256);

      // game_manager
      game_manager();
      virtual ~game_manager() {}
};


/* **********************************************************************
********************************************************************** */
class loader_list_type : public dbl_llist {

   public:
      void *ob;
      int type;

      virtual ~loader_list_type() {}
};


/* **********************************************************************
********************************************************************** */
class gamegod_type {

   protected:
      dbl_llist_manager font_manager;
  
   public:
      // timer
      timer_type    timer;
      // f/x manager
      fxmanager     teacher;

      // sound manager
      soundman      *soundmanager;
      // i/o manager
      user_io       *userinput;
      // gfx manager
      base_gfx      *gfx;

      // animated object manager
      dbl_llist_manager animation_manager;

      game_manager *boss;
      VIRTUALwindow *win;
      dbl_llist_manager resource_loader_manager;
 
      // font stack
      font_type *font;

      gamegod_type(engine *proc);
      virtual ~gamegod_type() { dest(); }

      void init();
      void reset();
      void dest();

      int set_sound_manager(soundman *sm);
      int set_io_manager(user_io *iom);
      int set_gfx_manager(base_gfx *gm);
      int set_game_manager(game_manager *gm);
      int set_win(VIRTUALwindow *w);
      void register_resource_loader(int type, void *ob);

      font_type *set_font(char *filename, int type);
};


/* **********************************************************************
********************************************************************** */
class gengine : public engine {

   protected:
      // engine
      void cullnsort(eye *parm, pc *list, pc **start_list, pc **final_list, int direction = SORT_ASCENDING);
      void cull(eye *parm, pc *list, pc **start_list, pc **final_list);

      // gengine
      int snapcount;
      int winx, winy;
      pc *flatdtr[MAXGROUND], *iflatdtr[MAXGROUND], *tflatdtr[MAXGROUND];

      void render_list(pc *ptr, int frame_id, int transflag);

   public:
      // engine
      void spawn(int frame_id, mapul *mapbuffer);
      void engine_init();
      void engine_submit(frameclass *ob);

      // gengine
      float *xbuff, *ybuff;
      float *xdata, *ydata;

      gengine();
      virtual ~gengine();

      void initbuff(unsigned int *d, puint *pd, float *zd, unsigned int x, unsigned int y, float backplane);
};


// gameglbl.c
extern unsigned char *byte_mult;

#define BYTE_MULT(iii, jjj) byte_mult[((iii)<<8)+(jjj)]

extern unsigned int *lut_red;
extern unsigned int *lut_green;
extern unsigned int *lut_blue;

extern vector4uc ogl_red;
extern vector4uc ogl_green;
extern vector4uc ogl_blue;

extern int game_fogflag[];
extern float game_fog_start, game_fog_end;
extern vector4f game_fog_color;

extern string_type FILENAME_FONT;

extern int FONTTYPE;

extern gengine proc;
extern gamegod_type *complex;

void init_gamegine(gamegod_type *god);
void shutdown_gamegine();

int parseinput(char *filename, void *callback = NULL);
void parseinput(int argc, char **argv, void *callback = NULL);
int writeinput(char *filename);

gameatom *load_gameatom(char *filename, dbl_llist_manager *hiearchy_manager);
gameatom *load_game_object(char *filename, dbl_llist_manager *hiearchy_manager);

#endif

