

#if !defined __FXMAN_H
#define __FXMAN_H

#include "gamequrk.h"

class fxmanager;


/* *************************************************************
************************************************************* */
class fx_type : public gamequark {

   public:
      // superclass
      int  query_whatami() { return OBJECT_FX_TYPE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // fx_type
      atom_list_type *owner;

      fx_type() { owner = NULL; }
      virtual ~fx_type() {}
      
      virtual void init() { flags |= QUARK_FLAG_ACTIVE; owner = NULL; }
      virtual void dest() {}
};


/* *************************************************************
************************************************************* */
class fx_launcher : public dbl_llist {

   protected:
      virtual fx_type *launch()  = 0;

   public:
      dbl_llist_manager armoury;

      virtual ~fx_launcher();

      linktype *issue(gameatom *parent);

      void reuse(linktype *item);

      virtual int  query_whatami() = 0;
      virtual char *query_name() = 0;
      virtual void preprocess(void *data);
};

typedef fx_launcher *pfx_launcher;


/* *************************************************************
************************************************************* */
class fxmanager : public gameatom {

   protected:
      dbl_llist_manager launcher;
      int max_fx;

      void launch(linktype *fx);
      void reuse(linktype *item);

   public:

      // superclass
      int  query_whatami() { return OBJECT_FXMANAGER; }
      int  query_whatwasi(int type);

      // quark
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fxmanager
      engine *mmanager;         // external

      fxmanager(engine *proc) : gameatom() { mmanager = proc; }
      virtual ~fxmanager() { }

      fx_type *issue(int isbn);
      unsigned int identify(char *name);

      void register_launcher(fx_launcher *node);

      void dest();
      void reset();
};


#endif

