

#if !defined __FONT_H
#define __FONT_H


#include "datatype.h"


#define FONT_NULL   0
#define FONT_VECTOR 1
#define FONT_RASTER 2

#define char2int(ci1, ci2, ci3, ci4) (ci1 | ((ci2 | ((ci3 | (ci4 << 8)) << 8)) << 8))


/* ***********************************************************************
*********************************************************************** */
class font_type : public dbl_llist {

   protected:
      float font_scale;
      union { vector4uc ccolor; unsigned int icolor; };
      
   public:
      string_type fontname;

      font_type() { icolor = 0; font_scale = 1; }
      virtual ~font_type() {}

      virtual int query_whatami() { return FONT_NULL; }
      virtual void set_color(char r, char g, char b) {}
      virtual int  read_data(char *filename) { return 0; }
      virtual void print(int x, int y, unsigned char *str, mapul *mapbuffer) {}
      virtual int  pixel_length(unsigned char *str) { return 0; }
      virtual void set_scale(float x) {}
};


/* ***********************************************************************
*********************************************************************** */


/* ***********************************************************************
*********************************************************************** */
class rasterchar {

   public:
      vector2f ll;
      vector2f ur;
      fixed_pt fssize;
      float fratio;
      
      texbase *tmap;

      rasterchar();
      int read_data(FILE *infile);
};


/* ***********************************************************************
*********************************************************************** */
class rasterfont : public font_type {

   protected:
      rasterchar *vfont;

   public:
      // font_type
      int query_whatami() { return FONT_RASTER; }
      void set_color(char r, char g, char b);
      int  read_data(char *filename);
      void print(int x, int y, unsigned char *str, mapul *mapbuffer);
      int  pixel_length(unsigned char *str);
      void set_scale(float x);

      rasterfont();
      virtual ~rasterfont() { if (vfont) delete [] vfont; }
};


/* ***********************************************************************
*********************************************************************** */



/* ***********************************************************************
	a polyline
*********************************************************************** */
class vectorflist {

   public:
      int count;
      vector2f *pt;

      vectorflist() { count = 0; pt = NULL; }
      virtual ~vectorflist() { if (pt) delete [] pt; }

      int  read_data(FILE *infile, char *token);
};


/* ***********************************************************************
	a polyline
*********************************************************************** */
class vectorilist {

   public:
      int count;
      vector2i *pt;

      vectorilist() { count = 0; pt = NULL; }
      virtual ~vectorilist() { if (pt) delete [] pt; }

      void set(vectorflist *flist, float scale);
      void print(int x, int y, unsigned int rgb, mapul *mapbuffer);
};


/* ***********************************************************************
	group of polylines that make up the char
*********************************************************************** */
class vectorchar {

   public:
      int count;
      vectorflist *master;
      vectorilist *v;
      float fsizex, fsizey;
      int isizex, isizey;

      vectorchar() { count = 0; master = NULL; v = NULL; }
      virtual ~vectorchar() { if (v) delete [] v; if (master) delete [] master; }

      int read_data(FILE *filename, char *token);
      int print(int *x, int y, unsigned int rgb, mapul *mapbuffer);
      void set_scale(float scale);
      virtual void init(int i);
};


/* ***********************************************************************
   uses FLIGHT vector font file format
*********************************************************************** */
class vectorfont : public font_type {

   protected:
      unsigned int rgb;                 // current color
      vectorchar *vfont;                // font
      float fsizey;                     // file height scale

   public:
      // font type
      int query_whatami() { return FONT_VECTOR; }
      int read_data(char *filename);
      void print(int x, int y, unsigned char *str, mapul *mapbuffer);
      void set_color(char r, char g, char b);
      int  pixel_length(unsigned char *str);
      void set_scale(float x);

      // vectorfont
      vectorfont();
      virtual ~vectorfont();

      virtual void init();
};


#endif
