



#if !defined (__FOLLOW_H)
#define __FOLLOW_H

#include "gamequrk.h"

/* *************************************************************
************************************************************* */
class follow : public gameatom {

   protected:
      string_type actor_name, target_name;
      quark *target;

   public:
      // superclass
      int  query_whatami() { return OBJECT_FOLLOW; }
      int  query_whatwasi(int type);

      // quark
      int  parse(FILE *infile, char *token);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // follow
      follow() { target = NULL; }
      virtual ~follow() {}
};


/* *************************************************************
************************************************************* */
class follow_loader : public quark_loader {

   public:
      superclass *make_object() { return new follow; }
      follow_loader() { object_name = alias_name = TOKEN_FOLLOW_STR; }
      virtual ~follow_loader() {}
};


/* *************************************************************
   essentially the same
************************************************************* */
class subfollow : public gamequark {

   protected:
      string_type actor_name, target_name;
      quark *target;

   public:
      // superclass
      int  query_whatami() { return OBJECT_SUBFOLLOW; }
      int  query_whatwasi(int type);

      // quark
      int  parse(FILE *infile, char *token);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // subfollow
      subfollow() { target = NULL; }
      virtual ~subfollow() {}
};


/* *************************************************************
************************************************************* */
class subfollow_loader : public quark_loader {

   public:
      superclass *make_object() { return new subfollow; }
      subfollow_loader() { object_name = alias_name = TOKEN_SUBFOLLOW_STR; }
      virtual ~subfollow_loader() {}
};

#endif
