

#if !defined __FLT_LOAD_H
#define __FLT_LOAD_H


#include "polytype.h"
#include "shading.h"


#define FLT_METER	0
#define FLT_KILOMETER	1
#define FLT_FEET	4
#define FLT_INCH	5
#define FLT_KNOT	8

#define TYPE_NULL  0
#define TYPE_FACE  1
#define TYPE_LIGHT 2

#define VERTEX_NULL	0x00
#define VERTEX_NORMAL	0x01
#define VERTEX_UV	0x02
#define VERTEX_COLOR    0x04
#define VERTEX_PACKED   0x08

#define OP_540_HEADER			1
#define OP_540_GROUP			2
#define OP_540_OBJECT			4
#define OP_540_FACE			5
#define OP_540_PUSH_LEVEL		10
#define OP_540_POP_LEVEL		11
#define OP_540_DOF			14
#define OP_540_PUSH_SUBFACE		19
#define OP_540_POP_SUBFACE		20
#define OP_540_PUSH_EXT			21
#define OP_540_POP_EXT			22
#define OP_540_TEXT_COMMENT		31
#define OP_540_COLOR_PALETTE		32
#define OP_540_LONG_ID			33
#define OP_540_MATRIX			49
#define OP_540_VECTOR			50
#define OP_540_BSP			55
#define OP_540_REPLICATE		60
#define OP_540_INSTANCE_REF		61
#define OP_540_INSTANCE_DEF		62
#define OP_540_EXTERNAL_REF		63
#define OP_540_TEXTURE_PALETTE		64
#define OP_540_VERTEX_PALETTE		67
#define OP_540_CVERTEX			68
#define OP_540_CNVERTEX			69
#define OP_540_CNTVERTEX		70
#define OP_540_CTVERTEX			71
#define OP_540_VLIST			72
#define OP_540_LOD			73
#define OP_540_BBOX			74
#define OP_540_ROTATE_EDGE		76
#define OP_540_TRANSLATE		78
#define OP_540_SCALE			79
#define OP_540_ROTATE_POINT		80
#define OP_540_ROTATESCALE_POINT	81
#define OP_540_PUT_TRANSFORM		82
#define OP_540_EYETRACK_PALETTE		83
#define OP_540_ROAD_SEGMENT		87
#define OP_540_ROAD_ZONE		88
#define OP_540_MORPH_VLIST		89
#define OP_540_BEHAVIOR_PALETTE		90
#define OP_540_SOUND			91
#define OP_540_ROAD_PATH		92
#define OP_540_SOUND_PALETTE		93
#define OP_540_GENERAL_MATRIX		94
#define OP_540_TEXT			95
#define OP_540_SWITCH			96
#define OP_540_LINE_STYLE		97
#define OP_540_CLIP_REGION		98
#define OP_540_EXTENSION		100
#define OP_540_LIGHT			101
#define OP_540_LIGHT_PALETTE		102
#define OP_540_BSPHERE			105
#define OP_540_BCYLINDER		106
#define OP_540_BVOLUME_CENTER		108
#define OP_540_BVOLUME_ORIENT		109
#define OP_540_LIGHT_POINT		111
#define OP_540_TMAP_PALETTE		112
#define OP_540_MATERIAL_PALETTE		113
#define OP_540_COLOR_NAME_PALETTE	114
#define OP_540_CAT			115
#define OP_540_CAT_DATA			116
#define OP_540_PUSH_ATTRIBUTE		122
#define OP_540_POP_ATTRIBUTE		123
#define OP_540_RESERVED124		124
#define OP_540_ADAPTIVE_ATTRIBUTE	125


typedef struct {
   unsigned  int index;
   vector3f  pt;
   vector3f  normal;
   vector2f  uv;
   int       color_index;
   vector4uc color;
   int       flags;
} vertex_type;


typedef struct {
   short          opcode;
   unsigned short size;
   unsigned char  id[8];
   unsigned int   formatrev;
   unsigned int   rev;
   unsigned char  date[32];
   short 	  groupid;		// 
   short  	  lodid;		//   
   short	  obj_id; 		// 
   short	  polygon_id;     	// 
   short	  scale;	        // short, + = multiply, 0 = nothing, - = divide w/o (-) // should be "1"
   char 	  unit;			// 0 = meter, 1 = kilometer, 4 = feet, 5 = inches, 8 = naut. miles
   char 	  texwhite;		// if true set texwhite on new polygons (not valid for 1000)
   int  	  flags;		// bit 0 = save vertex normals, 1-31 reserved
   char    padd[120];
   vector2d swlatlon;
   vector2d nelatlon;
} flt_sub_header;


/* *******************************************************************
******************************************************************* */
class material : public dbl_llist {

   public:
      int index;

      vector3f ambient, diffuse, specular, lum;
      float specn, alpha;

      material();
      virtual ~material() {}
};


/* *******************************************************************
******************************************************************* */
class work_material : public dbl_llist {

   public:
      int material_id;
      material *ilm;
      vector4uc facecolor;
      int count;
      
      work_material() { material_id = 0; count = 0; facecolor[0] = facecolor[1] = facecolor[2] = facecolor[3] = 255; }
      virtual ~work_material() { }
};


/* *******************************************************************
******************************************************************* */
class flt_loader : public file_loader {

   protected:
      // flt_loader
      flt_sub_header sub_header;

      vector4uc   *clist;

      int countedge;
      int countvertex;
      vertex_type *vlist;

      dbl_llist_manager tlist;
      dbl_llist_manager mlist;
      dbl_llist_manager flist;
      dbl_llist_manager master_flist;
      
      int current_type;
      
      void extract_material(work_material *src, shadetype *ilm);
      void post_object();
      void init();
      
      int export_spg(polytype *ob, int level);
      int export_ilm(shadelist *ilm, int level);
      int export_tex(texpolygon *texpoly, int level);

      void parse_subhead();
      void parse_lod(int size);
      void parse_vertex_index(int size);
      void parse_morph_vertex_index(int size);
      void parse_face(int size, vector4f *mx);
      void parse_vertex(int size, float scale);
      void parse_tex(int size);
      void parse_material(int size);
      void parse_color_palette(int size);
      void parse_matrix(int size, vector4f *mx);
      void parse_subface(int size);
      void parse_pushsface(int size);

   public:
      // basic_loader
      void cleanup();
      basic_loader *find_loader(sfile *data);

      // file_loader
      int query_levels();
      int read_data();
      void *extract(unsigned int type, char *altname, int level = 0);

      // flt_loader
      flt_loader() { clist = NULL; vlist = NULL; }
      virtual ~flt_loader() {}
};

#endif

