

#if !defined __FLAT_H
#define __FLAT_H

#include "glpolygon.h"
#include "gamequrk.h"

#define DEFAULT_FLAT_NAME   "default_flat_name"


/* ****************************************************************
**************************************************************** */
class flat : public polygon {

   protected:
      // pc
      void transform(eye *parm);

      // polygon
      void prepare_edge(engine *proc, int face, pointtype *start, pointtype *end, int starty, int endy, int texture_flag);

      // flat
      int  read_tex(char *filename);

      void flatr_0x00(eye *parm, engine *proc);
      void flatr_0x01(eye *parm, engine *proc);
      void flatr_0x02(eye *parm, engine *proc);
      void flatr_0x03(eye *parm, engine *proc);
      void flatr_0x04(eye *parm, engine *proc);
      void flatr_0x05(eye *parm, engine *proc);
      void flatbp_0x10(eye *parm, engine *proc);
      void flatbp_0x11(eye *parm, engine *proc);
      void flatbp_0x12(eye *parm, engine *proc);
      void flatbp_0x13(eye *parm, engine *proc);
      void flatbp_0x14(eye *parm, engine *proc);
      void flatbp_0x15(eye *parm, engine *proc);

   public:
      // superclass
      int  query_whatami() { return OBJECT_FLAT; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // pc
      int scan(camera *cparm, light *lmain, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      // flat
      unsigned int current_tex_id;
      float last_frame;

      virtual ~flat() {}
      unsigned int update_texture();
};


/* ****************************************************************
**************************************************************** */
class fxflat : public flat {

   public:
      // superclass
      int  query_whatami() { return OBJECT_FXFLAT; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // fxflat
      
      virtual ~fxflat() {}
      
      void set_ob_data(texbase *tob);
};


/* ****************************************************************
**************************************************************** */
class glflat : public glpolygon {

   protected:

      // gl_polygon
      void render_material();

      // glflat
      int  read_tex(char *filename, char *dfilename);

   public:
      // superclass
      int  query_whatami() { return OBJECT_GLFLAT; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // pc
      void datacopy();
      int scan(camera *cparm, light *lmain, engine *proc);
      void render(camera *cparm, light *lmain, light *spot, engine *proc);

      // glflat
      unsigned int current_tex_id;
      float last_frame;

      virtual ~glflat() {}
      
      unsigned int update_texture();
};


/* ****************************************************************
**************************************************************** */
class glfxflat : public glflat {

   public:
      // superclass
      void preprocess(void *data);

      // glfxflat
      
      virtual ~glfxflat() {}
      
      void set_ob_data(texbase *tob);
};


polytype *build_flat_data();

#endif

