

#if !defined __EYE_H
#define __EYE_H

#include "matrix.h"
#include "superclass.h"


/* *************************************************************
************************************************************* */
class eye : public frameclass {

   protected:
      vector4f frustum[6];

   public:
   
      // superclass
      int query_whatami() { return OBJECT_EYE; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);
      void preprocess(void *data) { frameclass::preprocess(data); }

      // eye
      vector3f location;
      vector3f vup;
      vector3f vpn;

      vector4f vrc;

      // used to size the viewport
      float mscale, imscale;

      vector4f transform[4];
      vector4f Tinverse[4];

      eye() {
         location[0] = location[1] = location[2] = 0;

         vup[0] = vup[2] = 0;
         vup[1] = 1;

         vpn[0] = vpn[1] = 0;
         vpn[2] = -1;

         vrc[0] = -(vrc[1] = (float)(4.0/3.0));
         vrc[2] = -1;
         vrc[3] = 1;

         imscale = mscale = 1;
      }

      virtual ~eye() {}
      
      void  nper();
      float query_scale() { return mscale; }
      void  calc_clip_plane();
      int   query_frustum_clip(float radius, float *center, float *dist, unsigned int frustum_flag = 0xffffffff);
      void  query_frustum(vector4f *v);

      virtual float zscale(float n, float d) = 0;
      virtual void  map2screen(float *v) = 0;
      virtual void  screen2map(float *v) = 0;
};

#endif
