

#if !defined __EQUIPMNT_H
#define __EQUIPMNT_H

#include "gamequrk.h"

#define CLASS_EQUIPMENT          20

#define EQUIP_GENERIC           150


class object_desc;

/* *************************************************************
************************************************************* */
class equipment : public dbl_llist {

   protected:
      virtual equipment *copy(equipment *item);

   public:

      // superclass
      virtual int  query_category() { return CLASS_EQUIPMENT; }
      virtual int  query_whatami() { return EQUIP_GENERIC; }
      virtual int  query_whatwasi(int type);
      virtual int  parse(FILE *infile, char *token);
      virtual void preprocess(void *data) { }

      // equipment
      string_type name;          // generic name for equipment
      string_type full_name;     // cosmetic name for display
      object_desc *gear;
      int maxhp, hp;
      float imaxhp;

      equipment() { maxhp = hp = 0; imaxhp = 1.0f; }
      virtual ~equipment() { }

      virtual equipment *clone() = 0;
      virtual void update(dbl_llist_manager *hiearchy_manager);
      virtual void update_fx(vector4f *mx);
      virtual void reset(gameatom *source, object_desc *ob);
      virtual void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);
      virtual void apply_damage(int *damage);
};

typedef equipment *pequipment;


/* *************************************************************
************************************************************* */
class equipment_loader : public dbl_llist {

   public:
      virtual ~equipment_loader() {}

      virtual char *query_name() = 0;
      equipment *parse(FILE *infile, char *token);

      virtual equipment *make_object() = 0;
};

/* *************************************************************
    current state of an object
************************************************************* */
class object_desc {

   protected:
      virtual void remove(equipment *item);

   public:
      dbl_llist_manager inventory;
      dbl_llist_manager non_functional;
      int hp, maxhp;

      virtual ~object_desc() {}

      void update_fx(vector4f *mx);
      void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);
      equipment *find_specific(int id);
      equipment *find_category(int id);
      
      virtual void init();
      virtual void update(dbl_llist_manager *hiearchy_manager);
};

#endif

