

/* *************************************************************
   This file contains all the global data types for my programs
************************************************************* */

#if !defined __DATATYPE_H
#define __DATATYPE_H


#include "superclass.h"
#include "map.h"
#include "matrix.h"


#define RESOURCE_OBJECT         0x00000001
#define RESOURCE_TEXTURE        0x00000002
#define RESOURCE_UVCOORD        0x00000003
#define RESOURCE_UVWCOORD       0x00000004
#define RESOURCE_MATERIAL       0x00000005

#define RESOURCE_SHADER         0x10000001
#define RESOURCE_IMAGE_LOADER   0x10000002
#define RESOURCE_POLYGON_LOADER 0x10000003
#define RESOURCE_OBJECT_LOADER  0x10000004

#define RESOURCE_FRAME_OBJECT   0x20000000

#define FILETYPE_NULL  0
#define FILETYPE_TEX   1
#define FILETYPE_SP    2
#define FILETYPE_ILM   3
#define FILETYPE_IMAGE 4
#define FILETYPE_TEX3D 5
#define FILETYPE_SPG   6

#define CBYTE_ORDER_ABGR 0
#define CBYTE_ORDER_ARGB 1
#define CBYTE_ORDER_BGRA 2
#define CBYTE_ORDER_RGBA 3


#define REDINDEX   0
#define GREENINDEX 1
#define BLUEINDEX  2

#define TEXTURE2D_QUERY_TEXTURE      0x01
#define TEXTURE2D_QUERY_FRAMECOUNT   0x02
#define TEXTURE2D_QUERY_UNIT_TEXTURE 0x03

#define IMAGE_GET_MIPMAP8  0x0001
#define IMAGE_GET_MIPMAP32 0x0002
#define IMAGE_SET_MIPMAP8  0x1001
#define IMAGE_SET_MIPMAP32 0x1002


/* *******************************************************************
******************************************************************* */
class basic_loader : public dbl_llist {

   protected:
      sfile *sinfile;

   public:
      basic_loader() { sinfile = NULL; }
      virtual ~basic_loader() {}

      virtual void cleanup();
      virtual basic_loader *find_loader(sfile *data) = 0;
};


/* ************************************************************************************
************************************************************************************ */
class image_coder : public basic_loader {

   public:
      // basic_loader
      virtual void cleanup();

      // image_coder
      virtual ~image_coder() {}

// asdf      virtual int query_whatami() = 0;
      virtual int scan_data(mapul *tob, int flip);
      virtual int scan_data256(mapuc *tob, unsigned int *palette, int flip);
      virtual int skim_data(int *maxx, int *maxy, int flip);
      virtual int query_256();

      virtual int write_data(char *fname, mapul *tob, int flip);
      virtual int write_compress(char *fname, mapul *tob, int flip);

      virtual int write_data256(char *fname, mapuc *tob, unsigned int *palette, int flip);
      virtual int write_compress256(char *fname, mapuc *tob, unsigned int *palette, int flip);

      virtual int perform_task(int type, void *data);
      virtual int extract(unsigned int type, void *data, int flip);
};


/* *******************************************************************
******************************************************************* */
class file_loader : public basic_loader {

   public:
      virtual ~file_loader() {}

      virtual int query_levels();
      virtual int read_data() = 0;
      virtual void *extract(unsigned int type, char *altname, int level = 0) = 0;
};


/* ********************************************************************
******************************************************************** */
class basic_texture_block {

   public:
      virtual ~basic_texture_block() {}

      virtual int query_whatami() = 0;
};


/* ********************************************************************
   Note: "next" deleted by whatever manages textures
******************************************************************** */
class texbase : public resource_type {

   public:
      // resource_type
      void *query_data() { return resource_type::query_data(); }
      int query_data(int type, void *key, void *response);

      // texbase
      int  maxx, maxy;     // rounded up to the next power of 2
      int  oldx, oldy;     // original texture size
      int  maskx, masky;   // maxx/y - 1
      int  bitx, bity;     // bit shift

      virtual ~texbase() {}

      virtual int query_whatami() = 0;

      virtual int pre_process_texture();
      virtual void build_mipmaps(dbl_llist_manager *image_handler, int flip);

      virtual int read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) = 0;
      virtual int skim_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) = 0;

      virtual unsigned int query_texel(float x, float y, float *color, int frame, float d) = 0;
};


typedef texbase *ptexbase;


/* *************************************************************
// Note: "next" deleted by "frame_manager"
************************************************************* */
class datatype : public resource_type {

   public:
      float    bs_radius;
      vector4f bs_center;

      datatype();
      virtual ~datatype() {}
      virtual int read_data(char *filename) = 0;
};


/* *************************************************************
************************************************************* */
class frame_manager : public resource_manager {

   protected:
      // resource_manager
      void local_init();
      void local_reset();
      
      // frame_manager
      dbl_llist_manager object_list;     // ptr to object list
      dbl_llist_manager material_list;   // ptr to material list
      dbl_llist_manager texture_list;    // ptr to texture list
      dbl_llist_manager uvcoord_list;    // ptr to UV list
      dbl_llist_manager uvwcoord_list;   // ptr to procedural texture mapping

      dbl_llist_manager poly_loader_list;
      binary_tree       proc_shader_list;
      dbl_llist_manager image_loader_list;
      dbl_llist_manager object_loader_list;

      int            vis_flag;        // render to screen
      int            flag256;         // support for 256 color palettes
      int            flipflag;        // determines byte order for textures
      void           *__postprocessCBtexture;
      void           *__cleanupCBtexture;

      int query_video(sfile *sinfile);

   public:

      // resource_manager
      void init(int x);
      void reset();

      void register_resource_object(int type, void *data);
      void *find_resource_object(int type, char *id, char *alias);
      void *get_resource_object(int type);
      void update(float current_time);

      // frame_manager
      frame_manager();
      virtual ~frame_manager();

      resource_type *read_spatch(char *filename);
      resource_type *read_tex(char *filename);
      resource_type *read_ilm(char *filename, int count);
      resource_type *read_tex3d(char *filename, char *dfilename, int objectcount);

      void set_postprocessCBtexture(void *x) { __postprocessCBtexture = x; }
      void set_cleanupCBtexture(void *x) { __cleanupCBtexture = x; }

      void set_render(int x) { vis_flag = x; }
      void set_color_byte_order(int x) { flipflag = x; }
      void set_palette_support(int x) { flag256 = x; }

      int query_render() { return vis_flag; }
      int query_palette_support() { return flag256; }
      int query_color_byte_order() { return flipflag; }

      int postprocessCBtexture(texbase *tob);
      int cleanupCBtexture(texbase *tob);

      virtual texbase *alloc_texture(sfile *sinfile, dbl_llist_manager *handler, image_coder **loader, int flag256);
};

#endif

