

#if !defined __DATAIO_H
#define __DATAIO_H


#include <stdio.h>

#include "basic_dt.h"


/* ***********************************************************************
*********************************************************************** */
class sfile {

   protected:
      void increment();
      
   public:
      string_type filename;
      unsigned char *data;
      unsigned int size, vsize;
      unsigned char *ptr;

      sfile() { init(); }
      virtual ~sfile() { dest(); }

      void init();
      void dest();
      
      int scan_data(char *fname, char *envstr = NULL, char slash = 0);
      int scan_data(buffer_type *buffer);
      int dump_data(char *fname);

      char scan_char();
      unsigned char scan_uchar();

      short scan_short();
      short scan_rshort();
      unsigned short scan_ushort();
      unsigned short scan_rushort();

      int scan_int();
      int scan_rint();
      unsigned int scan_uint();
      unsigned int scan_ruint();

      float scan_float();
      float scan_rfloat();

      double scan_double();
      double scan_rdouble();

      int  scan_token(char *buffer, int len);
      int  scanstring(char *buffer, int maxlen);

      void sput_char(char val);
      void sput_uchar(unsigned char val);

      void sput_short(short val);
      void sput_rshort(short val);
      void sput_ushort(unsigned short val);
      void sput_rushort(unsigned short val);

      void sput_int(int val);
      void sput_rint(int val);
      void sput_uint(unsigned int val);
      void sput_ruint(unsigned int val);

      void sput_float(float val);
      void sput_rfloat(float val);

      void sput_double(double val);
      void sput_rdouble(double val);

      int  sread(char *buffer, unsigned int len);
      char *sgets(char *buffer, unsigned int len);
      int  sgetc();
      
      void swrite(char *buffer, unsigned int len);

      void skip(int x);
      void sseek(unsigned int x);
      int  seof();
      int  speek();
};


float          getfloat(FILE *infile);
unsigned char  getuchar(FILE *infile);
unsigned short getushort(FILE *infile);
unsigned short getrushort(FILE *infile);
unsigned int   getuint(FILE *infile);
unsigned int   getruint(FILE *infile);
double         getdouble(FILE *infile);
int            getstring(FILE *infile, char *buffer, int maxlen);

void           putuchar(FILE *outfile, unsigned char val);
void           putushort(FILE *outfile, unsigned short val);
void           putrushort(FILE *outfile, unsigned short val);
void           putuint(FILE *outfile, unsigned int val);
void           putruint(FILE *outfile, unsigned int val);

int find_file(char *filename, char *oflags, char *envstr, char slash, char *out, FILE **infile);

#endif

