



#if !defined (__CONE_H)
#define __CONE_H

#include "geo.h"


/* *************************************************************
************************************************************* */
class cone : public geo {

   protected:

      // pc
      void transform(eye *parm);

      // geo
      void pg(eye *parm, light *lmain, light *spot, zbuffer *zbuff);
      void lt(spotlight *spot);
      void geo2poly(texpolygon **ptob, shaderlisttype *slist);
      float calc_area();
      
      // cone
      float master_length, length;
      float master_radius[2], radius[2];

   public:
      // superclass
      int  query_whatami() { return OBJECT_CONE; }
	  int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // frameclass
      int  dump_frame(FILE *outfile);
      
      // pc
      void bound_sphere();
      void datacopy();

      // cone
      cone() { master_length = master_radius[0] = master_radius[1] = 1; }
      virtual ~cone() {}
};


/* *************************************************************
************************************************************* */
class cone_loader : public loader {

   protected:
      superclass *make_object() { return new cone; }

   public:
      cone_loader() { object_name = TOKEN_GEOCONE_STR; }
      virtual ~cone_loader() {}
};

#endif

