

#if !defined __COLORTREE_H
#define __COLORTREE_H


#include "basic_dt.h"
#include "matrix.h"
#include "map.h"

#define FILTER_STDDEV          0
#define FILTER_WEIGHTED_STDDEV 1

#define color2index(xxx) (((xxx)[0] & 0xff) | (((xxx)[1] & 0xff)<<8) | (((xxx)[2] & 0xff)<<16))


/* **************************************************
************************************************** */
class colordata : public binary_data {

   public:
      union { unsigned int icolor; vector4uc ccolor; };
      
      int compare(binary_data *x);
      
      virtual ~colordata() {}
};


/* **************************************************
************************************************** */
class colornode : public binary_node {

   public:
      int count;
      colordata key_color;
      unsigned int index;
      
      colornode() { index = 0; count = 1; key = &key_color; }
      virtual ~colornode() { key = NULL; }
      
      binary_node *insert(binary_node *x);
      void build_list(dbl_llist_manager *x);
};


/* **************************************************
************************************************** */
class color_llist : public dbl_llist {

   public:
      colornode *color;

      color_llist() { color = NULL; }
      virtual ~color_llist() {}
};


/* **************************************************
************************************************** */
class colortree : public binary_tree {

   public:
      binary_node *insert(binary_node *x);
      int remove(binary_node *x);

      // colortree
      int count, pixel_count;
      vector3d mean;
      
      colortree() { count = pixel_count = 0; }
      virtual ~colortree() {}
      
      void build_list(dbl_llist_manager *x);
      void append(mapul *tob, int type);
};


/* **************************************************
************************************************** */
class tree_llist : public dbl_llist {

   public:
      colortree *tree;

      tree_llist() { tree = NULL; }
      virtual ~tree_llist() { if (tree) delete tree; }
};


/* **************************************************
************************************************** */
class list_manager_type : public dbl_llist_manager {

   protected:
      void calc_mean();

   public:
      vector3d mean;
      vector3d stddev;
      unsigned int total;
      
      virtual ~list_manager_type() { }

      void calc_stddev(unsigned int flag);
      void set_index(unsigned int x, char *buffer);
};


/* **************************************************
************************************************** */
class manager_node : public dbl_llist {

   public:
      list_manager_type list;
      virtual ~manager_node() { }
};


#endif

