

#if !defined __CAMERA_H
#define __CAMERA_H


#include "eye.h"


/* *************************************************************
************************************************************* */
class camera : public eye {

   public:
      // superclass
      int  query_category() { return CLASS_CAMERA; }
      int  query_whatami() { return OBJECT_CAMERA; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      
      // frameclass
      int  dump_frame(FILE *outfile);

      // eye
      float zscale(float n, float d) { return -n/d; }

      void map2screen(float *v) {
         float iz = 1.0f/v[2];

         v[0] = -mscale * (v[0]*iz + vrc[0]);
         v[1] = -mscale * (v[1]*iz + vrc[2]);
      }

      void screen2map(float *v) {
         v[0] = -(v[0]*imscale + vrc[0]) * v[2];
         v[1] = -(v[1]*imscale + vrc[2]) * v[2];
      }

      // camera
      vector3f coa;                     // center of attention

      camera();
      virtual ~camera() {}
      
      void set_dim(int x, int y);
      void set_dim(float fov, int x, int y);
      void  read_def(FILE *infile, unsigned int *x, unsigned int *y);
};


typedef camera *pcamera;

/* *************************************************************
************************************************************* */
class camera_loader : public loader {

   public:
      superclass *make_object() { return new camera(); }
      camera_loader() { object_name = TOKEN_CAMERA_STR; }
      virtual ~camera_loader() {}
};


#endif

