

#if !defined __BRAIN_H
#define __BRAIN_H


#include "gamequrk.h"

#define MAX_OBSTACLES   4
#define MAX_TARGET_TYPE    0x0f

#define AXIS_X 0
#define AXIS_Y 1
#define AXIS_Z 2


typedef struct {
   quark *ob;
   float dist;
} obstacle_type;


typedef struct {

   int type;
   int count;
   float yellow_radius, red_radius;
   obstacle_type target[MAX_OBSTACLES];
} avoid_type;


/* *****************************************************************************
***************************************************************************** */
class basic_targeting_pathway {

   protected:
      gameatom *source_atom;
      target_type last;
      unsigned int ormask, andmask;
      float range2;

      virtual int find_next(atom_list_type *subtree, quark *target, quark *parent, quark *stop);

   public:
      basic_targeting_pathway() { init(); }
      virtual ~basic_targeting_pathway() {}

      void init();

      void set_source(gameatom *child) { source_atom = child; }
      gameatom *get_source() { return source_atom; }
      void set_mask(unsigned int amask, unsigned int omask) { andmask = amask; ormask = omask; }
      void set_range(float distance) { if (distance < 0) range2 = -1; else range2 = distance*distance; }
      void set_last(target_type *x) { last = *x; }
      target_type *get_last() { return &last; }
      virtual void get_next_target(dbl_llist_manager *hiearchy_manager, target_type *target);
};


/* *****************************************************************************
	Target quarks w/in specified atom
***************************************************************************** */
class sub_targeting_pathway : public basic_targeting_pathway {

   public:
      virtual ~sub_targeting_pathway() {}

      void get_next_subtarget(atom_list_type *subtree, target_type *target);
};


/* *****************************************************************************
	Targets atoms
***************************************************************************** */
class master_targeting_pathway : public basic_targeting_pathway {

   public:
      virtual ~master_targeting_pathway() {}

      void get_next_target(dbl_llist_manager *hiearchy_manager, target_type *target);
      void get_nearest_target(dbl_llist_manager *hiearchy_manager, target_type *target);
      void get_center_target(dbl_llist_manager *hiearchy_manager, target_type *target);
};


/* *****************************************************************************
***************************************************************************** */
class type_targeting_pathway : public master_targeting_pathway {

   protected:
      unsigned int type_mask;

      int find_next(atom_list_type *subtree, quark *target, quark *parent, quark *stop);

   public:
      virtual ~type_targeting_pathway() {}

      void get_next_target(dbl_llist_manager *hiearchy_manager, target_type *target);
      void get_nearest_target(dbl_llist_manager *hiearchy_manager, target_type *target);
      void get_center_target(dbl_llist_manager *hiearchy_manager, target_type *target);

      void set_target_type(unsigned int x) { type_mask = x; }
      target_type *get_last() { return &last; }
      type_targeting_pathway() { type_mask = 0xffffffff; }
};


/* *****************************************************************************
***************************************************************************** */
class orient_pathway {

   public:
      virtual ~orient_pathway() {}

      void calc_orientation(float *curr_dir, float *target_dir, float dangular_vel, vector4f *out, int axis_id);
};


/* *****************************************************************************
***************************************************************************** */
class chase_pathway {

   public:
      virtual ~chase_pathway() {}

      void calc_velocity(float *dir, float *destdir, float dist2target, float maxspeed, float accel, float *vel, float speed, float *outvel, float *outspeed);
};


/* *****************************************************************************
***************************************************************************** */
class avoid_pathway {

   protected:
      void calc_alert(quark *source, quark *obstacle, quark *parent, float *vel, avoid_type *avoid_data);
      void plot_evasive_course(quark *source, avoid_type *avoid_data, float *vel, float *course);

   public:
      virtual ~avoid_pathway() {}

      int calc_avoid(atom *source, dbl_llist_manager *hiearchy_manager, float *vel, float speed, float dorient, float *course);
};


/* *****************************************************************************
***************************************************************************** */
class intercept_pathway {

   public:
      virtual ~intercept_pathway() {}

      int intercept_prediction(quark *target, float *source_pos, float source_speed, float *intercept_pos, float *intercept_time);
      int intercept_prediction(float *target_pos, float *target_vel, float *source_pos, float source_speed, float *intercept_pos, float *intercept_time);
};


/* *************************************************************
************************************************************* */
class movement_pathway {

   public:
      virtual ~movement_pathway() {}

      int whereami(vector4f *start_state, float angular_velocity, float time, float *target_pos, vector4f out_state);
};


unsigned int calc_enemy(unsigned int alliance);
int query_clear_los(quark *source, quark *target, quark *parent, float *pt, float *ray, quark **obstacle, float *pos, float *normal, int level);


#endif
