


#if !defined __BOID_H
#define __BOID_H

#include "wwdigo.h"


#define NO_COLLISION 0
#define RED_ALERT    1
#define YELLOW_ALERT 2

#define FLAG_BOID_NULL    0x00
#define FLAG_BOID_ALERT   0x01
#define FLAG_BOID_OBJECT  0x02
#define FLAG_BOID_LEAD    0x04

/* *************************************************************
************************************************************* */
typedef struct {

   quark *target;
   quark *parent;

   unsigned int flags;
} boid_avoid_type;


/* *************************************************************
   This is a boid class.  Since I can't see this as anything but
   it's own atom, with no children but other boids, I'm coding
   it as such

   Orientation - nose points down -Z, up points +Y

   so that boids are upright most of the time.  For turning,
   we want nose to be new direction, up "in" the turn - cross product
   old vector w/ new vector, use result w/ cross product of new vector.
   If no change in direction, use old vup. (Simulates bird flaps wings
   to change direction

   NOTE:  asdf this class is not set up to handle changes caused by
          applying the "scale" event
************************************************************* */
class boid : public wwdigo {

   protected:
      int gflag;                                // is there a gravity/force vector
      vector3f gravity;                         // gravity vector - "pull" of gravity

      float max_accel, minspeed, maxspeed, velocity;
      float ra_radius, ya_radius;
      float ya_weight;                          // yellow alert weight
      float ifps;                               // inverse friction per sec....
      float icl;                                // inverse collision loss
      float nb_min_radius, nb_max_radius;       // nearest bird radii squared
      float nl_min_radius, nl_max_radius;       // nearest leader radii squared
      float max_turn_rad;

      vector3f global_dir, local_dir, vup;
                                                // temporary bounding data
      vector4f ybdata[8];
      vector4f rbdata[8];

      union {
         vector4f ybnormal[6];
         vector4f ybplane;
      };

      union {
         vector4f rbnormal[6];
         vector4f rbplane;
      };

      float yradius, rradius;
						// work variables
      vector4f old_imx[4];			// inverse orientation mx
      int      alert;				// current alert value
      quark    *nearest_leader, *nearest_boid;	// nearest objects for flocking
      float    nl_dist, nb_dist;		// respective distances
      vector3f avoid_dir;			// direction to run to

      void calc_bound();
      void box_normals(vector4f *in_data, vector4f *out_normal);
      void bound_rect(vector4f *in_data, float radius, vector4f *out_data);
      void add2path(float *target, float *me, float dist, float maxdist, float *weight, float *want);
      void sub2path(float *target, float *me, float dist, float maxdist, float *weight, float *want);

      int  calc_avoid(float *avoid, quark *qtr, int *aflag);
      void calc_dist_data(boid_avoid_type *data);

      void calc_reflect(quark *drunk, float *dir, float *ref);
      int  query_collision(quark *drunk);

   public:

      // superclass
      int  query_whatami() { return OBJECT_BOID; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);

      // quark
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // boid
      boid();
      virtual ~boid() {}
};


/* *************************************************************
************************************************************* */
class boid_loader : public quark_loader {

   public:
      superclass *make_object() { return new boid; }

      boid_loader() { object_name = alias_name = TOKEN_BOID_STR; }
      virtual ~boid_loader() {}
};


/* *************************************************************
************************************************************* */
class boidbait: public quark {

   public:
      // superclass
      int query_whatami() { return OBJECT_BOIDBAIT; }
      int query_whatwasi(int type);

      virtual ~boidbait() {}
};


/* *************************************************************
************************************************************* */
class boidbait_loader : public quark_loader {

   public:
      superclass *make_object() { return new boidbait; }
      boidbait_loader() { object_name = alias_name = TOKEN_BOIDBAIT_STR; }

      virtual ~boidbait_loader() {}
};


#endif

